<?php
/*
Plugin Name: CasinoMaxius Editable Popup
Description: CasinoMaxius Editable Popup (ShortCode[EDITABLE_POPUP])
Version: 1.0
Author: ICON Technology
Author URI: https://icontechnology.co.in
*/

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
if( !class_exists( 'editable_popup' ) ){
	class editable_popup{
		function __construct(){
			global $wpdb;
			require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
			$table_nm=$wpdb->prefix . 'editable_popup';
			$charset_collate = $wpdb->get_charset_collate();

			$sql="CREATE TABLE IF NOT EXISTS $table_nm(`ep_id` int(10) NOT NULL AUTO_INCREMENT,
				`ep_bg_image` longtext NOT NULL,
				`ep_heading_text` text NOT NULL,
				`ep_details` longtext NOT NULL,
				`ep_text_color` text NOT NULL,
				`ep_button_text` text NOT NULL,
				`ep_button_url` text NOT NULL,
				`ep_button_text_color` text NOT NULL,
				`ep_button_bg_color` text NOT NULL,
				
				PRIMARY KEY (`ep_id`)
			)$charset_collate;";
			dbDelta($sql);
		}

		function activation(){
			flush_rewrite_rules();
		}
		function deactivation(){
			flush_rewrite_rules();

		}
		function includes(){
			add_action('admin_menu',array($this,'admin_menu_setting'));
			add_action('admin_enqueue_scripts',array($this,'custom_admin_enqueue'));
			 require_once plugin_dir_path(__FILE__).'includes/popup_html_shortcode.php';
			
		}
		

		
		
		function custom_admin_enqueue(){
			wp_enqueue_media();
			wp_enqueue_script( 'custom2_script_js', plugin_dir_url(__FILE__).'includes/js/custom.js','','',false );
		}
		function admin_menu_setting(){
			add_menu_page(
				'Editable Popup',
				'Editable Popup',
				'administrator',
				'editable_popup',
				array($this,'editable_popup_data'),
				'dashicons-forms',
				'50'
			);

		}
		function editable_popup_data(){
			include "includes/editable_popup_data_add.php";
		}
	}
}
if(class_exists('editable_popup')){
	$editable_popup = new editable_popup();
	$editable_popup->includes();
}
register_activation_hook(__FILE__,array($editable_popup,'activation'));
register_deactivation_hook(__FILE__,array($editable_popup,'deactivation'));

?>