<?php
if ( ! defined( 'ABSPATH' ) ) {
	die; // If this file is called directly, abort.
}
if(!class_exists('Popup_Shortcode')){

	class Popup_Shortcode{

		function __construct() {
	        
			add_shortcode( 'EDITABLE_POPUP', array( $this, 'Popup_Shortcode' ) );
			add_action('wp_enqueue_scripts',array($this,'add_style_script'));
			
		}
		function add_style_script()
		{
			wp_register_style( 'popup_css', plugin_dir_url(__File__).'css/popup-style.css',false  );
			
		}
		function Popup_Shortcode(){
			ob_start();
            ?>
            <link href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
            <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap" rel="stylesheet">
            <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
			<?php 
            wp_enqueue_style('popup_css');
            global $wpdb;
           
            $table_nm=$wpdb->prefix . 'editable_popup';
            ?>
            <?php
            $query = $wpdb->prepare("SELECT * FROM $table_nm ");
            $result = $wpdb->get_results($query);
            if($result){
             foreach ($result as $value) 
             {
			?>
			<style>
               
				.popup-section .popup-card-wapper h3{
                        color: <?= $value->ep_text_color  ; ?>;
                 
                    }
                    .popup-section .popup-card-wapper p{
                        color:<?= $value->ep_text_color  ; ?>;
                    }
                    .popup-section .popup-card-wapper .get-started-btn a{
                      
                        background: <?= $value->ep_button_bg_color  ; ?> ;
                        color: <?= $value->ep_button_text_color 	;?>;
                        
                    }
                    .pum-container .pum-content + .pum-close{
                        display:none;
                    }
			</style>
			<div class="popup-section">
                <div class="container w-1440">
                    <div class="popup-card-wapper">
                            <div class="popup-close-btn">
                                <a href="#" class=" popmake-close"><svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M13.7071 1.70711C14.0976 1.31658 14.0976 0.683417 13.7071 0.292893C13.3166 -0.097631 12.6834 -0.097631 12.2929 0.292893L7 5.58579L1.70711 0.292893C1.31658 -0.097631 0.683417 -0.097631 0.292893 0.292893C-0.097631 0.683417 -0.097631 1.31658 0.292893 1.70711L5.58579 7L0.292893 12.2929C-0.097631 12.6834 -0.097631 13.3166 0.292893 13.7071C0.683417 14.0976 1.31658 14.0976 1.70711 13.7071L7 8.41421L12.2929 13.7071C12.6834 14.0976 13.3166 14.0976 13.7071 13.7071C14.0976 13.3166 14.0976 12.6834 13.7071 12.2929L8.41421 7L13.7071 1.70711Z" fill="white"/>
                                </svg></a>
                            </div>
                            <h3><?= $value->ep_heading_text ; ?></h3>
                            <p><?= $value->ep_details; ?> </p>
                            <div class="get-started-btn">
                                <a href="<?= $value->ep_button_url ; ?>"><?= $value->ep_button_text ; ?></a>
                            </div>
                    </div>
                </div>
            </div>
	  <?php
             } }				
			return ob_get_clean();
		}
		
	}
}
if(class_exists('Popup_Shortcode')){
	$pshortcode = new Popup_Shortcode();
}
?>