<?php
/*
Plugin Name: ThirstyAffiliates Extended
Description: Extends the functionality of the ThirstyAffiliates plugin to handle special query strings in redirect URLs.
Author: Leonardo Diaz
Version: 1.0.2
Text Domain: thirstyaffiliates-pro
*/

// Asegurémonos de que no estamos exponiendo ninguna información si se llama directamente
if (!defined('ABSPATH')) {
    exit;
}

// Verificamos si ThirstyAffiliates pro está activo
include_once(ABSPATH . 'wp-admin/includes/plugin.php');

$plugin_slug = 'thirstyaffiliates/thirstyaffiliates.php';

// Comprobar si el plugin está activo
if (is_plugin_active($plugin_slug)) {

    // Definir una función para modificar la URL de redirección
    function ta_extended_filter_redirect_url($redirect_url, $thirstylink, $query_string = '') {
        $redirect_url = preg_replace('/&\!/', '', $redirect_url);
        $redirect_url = preg_replace('/\?\!/', '', $redirect_url);
        return $redirect_url;
    }

    // Añadir la función como un filtro para modificar la URL de redirección
    add_filter('ta_filter_redirect_url', 'ta_extended_filter_redirect_url', 20, 3);
} else {
    // Si el plugin no está activo, mostrar una notificación en el panel de administración
    add_action('admin_notices', 'my_admin_notice');
    function my_admin_notice() {
?>
        <div class="notice notice-warning is-dismissible">
            <p><?php _e('ThirstyAffiliates Pro plugin is required!', 'thirstyaffiliates-pro'); ?></p>
        </div>
<?php
    }
}
