<?php
namespace ThirstyAffiliates_Pro\Helpers;

use ThirstyAffiliates_Pro\Abstracts\Abstract_Main_Plugin_Class;

if ( !defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Model that houses all the plugin constants.
 * Note as much as possible, we need to make this class succinct as the only purpose of this is to house all the constants that is utilized by the plugin.
 * Therefore we omit class member comments and minimize comments as much as possible.
 * In fact the only verbouse comment here is this comment you are reading right now.
 * And guess what, it just got worse coz now this comment takes 5 lines instead of 3.
 *
 * @since 1.0.0
 */
class Plugin_Constants {

    /*
    |--------------------------------------------------------------------------
    | Class Properties
    |--------------------------------------------------------------------------
    */

    private static $_instance;

    public $_MAIN_PLUGIN_FILE_PATH;
    public $_PLUGIN_DIR_PATH;
    public $_PLUGIN_DIR_URL;
    public $_PLUGIN_DIRNAME;
    public $_PLUGIN_BASENAME;
    public $_CSS_ROOT_URL;
    public $_IMAGES_ROOT_URL;
    public $_JS_ROOT_URL;
    public $_VIEWS_ROOT_PATH;
    public $_TEMPLATES_ROOT_PATH;
    public $_LOGS_ROOT_PATH;
    public $_MESC_ROOT_PATH;
    public $_UPLOADS_DIR;
    public $_TA_UPLOADS_DIR;

    // Plugin configuration constants
    const TOKEN               = 'tap';
    const INSTALLED_VERSION   = 'tap_installed_version';
    const VERSION             = TAP_VERSION;
    const TEXT_DOMAIN         = 'thirstyaffiliates-pro';
    const THEME_TEMPLATE_PATH = 'thirstyaffiliates-pro';
    const META_DATA_PREFIX    = '_ta_';

    // Mothership & license
    const MOTHERSHIP_URL           = 'https://mothership.caseproof.com';
    const OPTION_EDGE_UPDATES      = 'tap_mothership_edge_updates';
    const OPTION_LICENSE_KEY       = 'tap_slmw_license_key';
    const OPTION_ACTIVATION_EMAIL  = 'tap_slmw_activation_email';
    const OPTION_LICENSE_ACTIVATED = 'tap_license_activated';

    // CPT Taxonomy constants
    const AFFILIATE_LINKS_CPT    = 'thirstylink';
    const AFFILIATE_LINKS_TAX    = 'thirstylink-category';
    const DEFAULT_LINK_CATEGORY  = 'Uncategorized';
    const EVENT_NOTIFICATION_TAX = 'tap-event-notification';

    // CRON
    const LINK_HEALTH_CHECKER    = 'tap_link_health_checker';

    // Amazon Module
    const LAST_USED_SEARCH_ENDPOINT   = 'tap_last_used_search_endpoint';
    const AMAZON_TABLE_COLUMNS        = 'tap_amazon_table_columns';
    const AMAZON_GENERATED_TRANSIENTS = 'tap_amazon_generated_transient'; // Option that holds the keys of all transients generated by amazon module

    // URL Shortener
    const BITLY_API_URL             = 'https://api-ssl.bitly.com/v3/';
    const GOOGL_SHORTENER_URL       = 'https://www.googleapis.com/urlshortener/v1/url';
    const FIREBASE_DL_SHORTENER_URL = 'https://firebasedynamiclinks.googleapis.com/v1/shortLinks';

    // Settings Constants

    // DB Tables
    const LINK_CLICK_DB      = 'ta_link_clicks';
    const LINK_CLICK_META_DB = 'ta_link_clicks_meta';

    // Help Section
    const CLEAN_UP_PLUGIN_OPTIONS = 'tap_clean_up_plugin_options';




    /*
    |--------------------------------------------------------------------------
    | Class Methods
    |--------------------------------------------------------------------------
    */

    public function __construct( Abstract_Main_Plugin_Class $main_plugin ) {

        // Path constants
        $this->_MAIN_PLUGIN_FILE_PATH = WP_PLUGIN_DIR . DIRECTORY_SEPARATOR . 'thirstyaffiliates-pro' . DIRECTORY_SEPARATOR . 'thirstyaffiliates-pro.php';
        $this->_PLUGIN_DIR_PATH       = plugin_dir_path( $this->_MAIN_PLUGIN_FILE_PATH );
        $this->_PLUGIN_DIR_URL        = plugin_dir_url( $this->_MAIN_PLUGIN_FILE_PATH );
        $this->_PLUGIN_DIRNAME        = plugin_basename( dirname( $this->_MAIN_PLUGIN_FILE_PATH ) );
        $this->_PLUGIN_BASENAME       = plugin_basename( $this->_MAIN_PLUGIN_FILE_PATH );

        $this->_CSS_ROOT_URL          = $this->_PLUGIN_DIR_URL . 'css/';
        $this->_IMAGES_ROOT_URL       = $this->_PLUGIN_DIR_URL . 'images/';
        $this->_JS_ROOT_URL           = $this->_PLUGIN_DIR_URL . 'js/';

        $this->_VIEWS_ROOT_PATH       = $this->_PLUGIN_DIR_PATH . 'views/';
        $this->_TEMPLATES_ROOT_PATH   = $this->_PLUGIN_DIR_PATH . 'templates/';
        $this->_LOGS_ROOT_PATH        = $this->_PLUGIN_DIR_PATH . 'logs/';
        $this->_MESC_ROOT_PATH        = $this->_PLUGIN_DIR_PATH . 'mesc/';

        $this->_UPLOADS_DIR           = wp_upload_dir();
        $this->_TA_UPLOADS_DIR        = trailingslashit( $this->_UPLOADS_DIR[ 'basedir' ] ) . 'thirstyaffilates/';

        $main_plugin->add_to_public_helpers( $this );

    }

    public static function get_instance( Abstract_Main_Plugin_Class $main_plugin ) {

        if ( !self::$_instance instanceof self )
            self::$_instance = new self( $main_plugin );

        return self::$_instance;

    }

    public function MAIN_PLUGIN_FILE_PATH() {
        return $this->_MAIN_PLUGIN_FILE_PATH;
    }

    public function PLUGIN_DIR_PATH() {
        return $this->_PLUGIN_DIR_PATH;
    }

    public function PLUGIN_DIR_URL() {
        return $this->_PLUGIN_DIR_URL;
    }

    public function PLUGIN_DIRNAME() {
        return $this->_PLUGIN_DIRNAME;
    }

    public function PLUGIN_BASENAME() {
        return $this->_PLUGIN_BASENAME;
    }

    public function CSS_ROOT_URL() {
        return $this->_CSS_ROOT_URL;
    }

    public function IMAGES_ROOT_URL() {
        return $this->_IMAGES_ROOT_URL;
    }

    public function JS_ROOT_URL() {
        return $this->_JS_ROOT_URL;
    }

    public function VIEWS_ROOT_PATH() {
        return $this->_VIEWS_ROOT_PATH;
    }

    public function TEMPLATES_ROOT_PATH() {
        return $this->_TEMPLATES_ROOT_PATH;
    }

    public function LOGS_ROOT_PATH() {
        return $this->_LOGS_ROOT_PATH;
    }

    public function MESC_ROOT_PATH() {
        return $this->_MESC_ROOT_PATH;
    }

    public function TA_UPLOADS_DIR() {
        return $this->_TA_UPLOADS_DIR;
    }

    // Amazon Module

    // Reference : https://webservices.amazon.com/paapi5/documentation/common-request-parameters.html#host-and-region
    public function AMAZON_SEARCH_COUNTRIES() {

        return array(
            'US' => __( 'United States' , 'thirstyaffiliates-pro' ),
            'CA' => __( 'Canada' , 'thirstyaffiliates-pro' ),
            'UK' => __( 'United Kingdom' , 'thirstyaffiliates-pro' ),
            'AU' => __( 'Australia' , 'thirstyaffiliates-pro' ),
            'BR' => __( 'Brazil' , 'thirstyaffiliates-pro' ),
            'FR' => __( 'France' , 'thirstyaffiliates-pro' ),
            'DE' => __( 'Germany' , 'thirstyaffiliates-pro' ),
            'IN' => __( 'India' , 'thirstyaffiliates-pro' ),
            'IT' => __( 'Italy' , 'thirstyaffiliates-pro' ),
            'JP' => __( 'Japan' , 'thirstyaffiliates-pro' ),
            'MX' => __( 'Mexico' , 'thirstyaffiliates-pro' ),
            'NL' => __( 'Netherlands' , 'thirstyaffiliates-pro' ),
            'PL' => __( 'Poland' , 'thirstyaffiliates-pro' ),
            'SA' => __( 'Saudi Arabia' , 'thirstyaffiliates-pro' ),
            'SG' => __( 'Singapore' , 'thirstyaffiliates-pro' ),
            'ES' => __( 'Spain' , 'thirstyaffiliates-pro' ),
            'SE' => __( 'Sweden' , 'thirstyaffiliates-pro' ),
            'TR' => __( 'Turkey' , 'thirstyaffiliates-pro' ),
            'AE' => __( 'United Arab Emirates' , 'thirstyaffiliates-pro' ),
        );

    }

    // Reference : https://webservices.amazon.com/paapi5/documentation/locale-reference.html
    public function AMAZON_SEARCH_INDEX() {

        return array(
            'AU' => array(
                'All' => __( '-- All Departments --', 'thirstyaffiliates-pro' ),
                'Automotive' => __( 'Automotive', 'thirstyaffiliates-pro' ),
                'Baby' => __( 'Baby', 'thirstyaffiliates-pro' ),
                'Beauty' => __( 'Beauty & Personal Care', 'thirstyaffiliates-pro' ),
                'Books' => __( 'Books', 'thirstyaffiliates-pro' ),
                'Computers' => __( 'Computers', 'thirstyaffiliates-pro' ),
                'Electronics' => __( 'Electronics', 'thirstyaffiliates-pro' ),
                'EverythingElse' => __( 'Everything Else', 'thirstyaffiliates-pro' ),
                'Fashion' => __( 'Clothing & Shoes', 'thirstyaffiliates-pro' ),
                'GiftCards' => __( 'Gift Cards', 'thirstyaffiliates-pro' ),
                'HealthPersonalCare' => __( 'Health, Household & Personal Care', 'thirstyaffiliates-pro' ),
                'HomeAndKitchen' => __( 'Home & Kitchen', 'thirstyaffiliates-pro' ),
                'KindleStore' => __( 'Kindle Store', 'thirstyaffiliates-pro' ),
                'Lighting' => __( 'Lighting', 'thirstyaffiliates-pro' ),
                'Luggage' => __( 'Luggage & Travel Gear', 'thirstyaffiliates-pro' ),
                'MobileApps' => __( 'Apps & Games', 'thirstyaffiliates-pro' ),
                'MoviesAndTV' => __( 'Movies & TV', 'thirstyaffiliates-pro' ),
                'Music' => __( 'CDs & Vinyl', 'thirstyaffiliates-pro' ),
                'OfficeProducts' => __( 'Stationery & Office Products', 'thirstyaffiliates-pro' ),
                'PetSupplies' => __( 'Pet Supplies', 'thirstyaffiliates-pro' ),
                'Software' => __( 'Software', 'thirstyaffiliates-pro' ),
                'SportsAndOutdoors' => __( 'Sports, Fitness & Outdoors', 'thirstyaffiliates-pro' ),
                'ToolsAndHomeImprovement' => __( 'Home Improvement', 'thirstyaffiliates-pro' ),
                'ToysAndGames' => __( 'Toys & Games', 'thirstyaffiliates-pro' ),
                'VideoGames' => __( 'Video Games', 'thirstyaffiliates-pro' ),
            ),
            'BR' => array(
                'All' => __( '-- All Departments --', 'thirstyaffiliates-pro' ),
                'Books' => __( 'Books', 'thirstyaffiliates-pro' ),
                'Computers' => __( 'Computers', 'thirstyaffiliates-pro' ),
                'Electronics' => __( 'Electronics', 'thirstyaffiliates-pro' ),
                'HomeAndKitchen' => __( 'Home & Kitchen', 'thirstyaffiliates-pro' ),
                'KindleStore' => __( 'Kindle Store', 'thirstyaffiliates-pro' ),
                'MobileApps' => __( 'Apps & Games', 'thirstyaffiliates-pro' ),
                'OfficeProducts' => __( 'Stationery & Office Products', 'thirstyaffiliates-pro' ),
                'ToolsAndHomeImprovement' => __( 'Home Improvement', 'thirstyaffiliates-pro' ),
                'VideoGames' => __( 'Video Games', 'thirstyaffiliates-pro' ),
            ),
            'CA' => array(
                'All' => __( '-- All Departments --', 'thirstyaffiliates-pro' ),
                'Apparel' => __( 'Clothing & Accessories', 'thirstyaffiliates-pro' ),
                'Automotive' => __( 'Automotive', 'thirstyaffiliates-pro' ),
                'Baby' => __( 'Baby', 'thirstyaffiliates-pro' ),
                'Beauty' => __( 'Beauty & Personal Care', 'thirstyaffiliates-pro' ),
                'Books' => __( 'Books', 'thirstyaffiliates-pro' ),
                'Classical' => __( 'Classical Music', 'thirstyaffiliates-pro' ),
                'Electronics' => __( 'Electronics', 'thirstyaffiliates-pro' ),
                'EverythingElse' => __( 'Everything Else', 'thirstyaffiliates-pro' ),
                'ForeignBooks' => __( 'English Books', 'thirstyaffiliates-pro' ),
                'GardenAndOutdoor' => __( 'Patio, Lawn & Garden', 'thirstyaffiliates-pro' ),
                'GiftCards' => __( 'Gift Cards', 'thirstyaffiliates-pro' ),
                'GroceryAndGourmetFood' => __( 'Grocery & Gourmet Food', 'thirstyaffiliates-pro' ),
                'Handmade' => __( 'Handmade', 'thirstyaffiliates-pro' ),
                'HealthPersonalCare' => __( 'Health & Personal Care', 'thirstyaffiliates-pro' ),
                'HomeAndKitchen' => __( 'Home & Kitchen', 'thirstyaffiliates-pro' ),
                'Industrial' => __( 'Industrial & Scientific', 'thirstyaffiliates-pro' ),
                'Jewelry' => __( 'Jewelry', 'thirstyaffiliates-pro' ),
                'KindleStore' => __( 'Kindle Store', 'thirstyaffiliates-pro' ),
                'Luggage' => __( 'Luggage & Bags', 'thirstyaffiliates-pro' ),
                'LuxuryBeauty' => __( 'Luxury Beauty', 'thirstyaffiliates-pro' ),
                'MobileApps' => __( 'Apps & Games', 'thirstyaffiliates-pro' ),
                'MoviesAndTV' => __( 'Movies & TV', 'thirstyaffiliates-pro' ),
                'Music' => __( 'Music', 'thirstyaffiliates-pro' ),
                'MusicalInstruments' => __( 'Musical Instruments, Stage & Studio', 'thirstyaffiliates-pro' ),
                'OfficeProducts' => __( 'Office Products', 'thirstyaffiliates-pro' ),
                'PetSupplies' => __( 'Pet Supplies', 'thirstyaffiliates-pro' ),
                'Shoes' => __( 'Shoes & Handbags', 'thirstyaffiliates-pro' ),
                'Software' => __( 'Software', 'thirstyaffiliates-pro' ),
                'SportsAndOutdoors' => __( 'Sports & Outdoors', 'thirstyaffiliates-pro' ),
                'ToolsAndHomeImprovement' => __( 'Tools & Home Improvement', 'thirstyaffiliates-pro' ),
                'ToysAndGames' => __( 'Toys & Games', 'thirstyaffiliates-pro' ),
                'VHS' => __( 'VHS', 'thirstyaffiliates-pro' ),
                'VideoGames' => __( 'Video Games', 'thirstyaffiliates-pro' ),
                'Watches' => __( 'Watches', 'thirstyaffiliates-pro' ),
            ),
            'FR' => array(
                'All' => __( '-- All Departments --', 'thirstyaffiliates-pro' ),
                'Apparel' => __( 'Clothing & Accessories', 'thirstyaffiliates-pro' ),
                'Appliances' => __( 'Appliances', 'thirstyaffiliates-pro' ),
                'Automotive' => __( 'Automotive Parts & Accessories', 'thirstyaffiliates-pro' ),
                'Baby' => __( 'Baby', 'thirstyaffiliates-pro' ),
                'Beauty' => __( 'Beauty & Personal Care', 'thirstyaffiliates-pro' ),
                'Books' => __( 'Books', 'thirstyaffiliates-pro' ),
                'Computers' => __( 'Computers', 'thirstyaffiliates-pro' ),
                'DigitalMusic' => __( 'Digital Music', 'thirstyaffiliates-pro' ),
                'Electronics' => __( 'Electronics', 'thirstyaffiliates-pro' ),
                'EverythingElse' => __( 'Everything Else', 'thirstyaffiliates-pro' ),
                'Fashion' => __( 'Clothing, Shoes & Jewelry', 'thirstyaffiliates-pro' ),
                'ForeignBooks' => __( 'Foreign Books', 'thirstyaffiliates-pro' ),
                'GardenAndOutdoor' => __( 'Garden & Outdoor', 'thirstyaffiliates-pro' ),
                'GiftCards' => __( 'Gift Cards', 'thirstyaffiliates-pro' ),
                'GroceryAndGourmetFood' => __( 'Grocery & Gourmet Food', 'thirstyaffiliates-pro' ),
                'Handmade' => __( 'Handmade', 'thirstyaffiliates-pro' ),
                'HealthPersonalCare' => __( 'Health, Household & Baby Care', 'thirstyaffiliates-pro' ),
                'HomeAndKitchen' => __( 'Home & Kitchen', 'thirstyaffiliates-pro' ),
                'Industrial' => __( 'Industrial & Scientific', 'thirstyaffiliates-pro' ),
                'Jewelry' => __( 'Jewelry', 'thirstyaffiliates-pro' ),
                'KindleStore' => __( 'Kindle Store', 'thirstyaffiliates-pro' ),
                'Lighting' => __( 'Lighting', 'thirstyaffiliates-pro' ),
                'Luggage' => __( 'Luggage & Travel Gear', 'thirstyaffiliates-pro' ),
                'LuxuryBeauty' => __( 'Luxury Beauty', 'thirstyaffiliates-pro' ),
                'MobileApps' => __( 'Apps & Games', 'thirstyaffiliates-pro' ),
                'MoviesAndTV' => __( 'Movies & TV', 'thirstyaffiliates-pro' ),
                'Music' => __( 'CDs & Vinyl', 'thirstyaffiliates-pro' ),
                'MusicalInstruments' => __( 'Musical Instruments', 'thirstyaffiliates-pro' ),
                'OfficeProducts' => __( 'Office Products', 'thirstyaffiliates-pro' ),
                'PetSupplies' => __( 'Pet Supplies', 'thirstyaffiliates-pro' ),
                'Shoes' => __( 'Shoes', 'thirstyaffiliates-pro' ),
                'Software' => __( 'Software', 'thirstyaffiliates-pro' ),
                'SportsAndOutdoors' => __( 'Sports & Outdoors', 'thirstyaffiliates-pro' ),
                'ToolsAndHomeImprovement' => __( 'Tools & Home Improvement', 'thirstyaffiliates-pro' ),
                'ToysAndGames' => __( 'Toys & Games', 'thirstyaffiliates-pro' ),
                'VHS' => __( 'VHS', 'thirstyaffiliates-pro' ),
                'VideoGames' => __( 'Video Games', 'thirstyaffiliates-pro' ),
                'Watches' => __( 'Watches', 'thirstyaffiliates-pro' ),
            ),
            'DE' => array(
                'All' => __( '-- All Departments --', 'thirstyaffiliates-pro' ),
                'AmazonVideo' => __( 'Prime Video', 'thirstyaffiliates-pro' ),
                'Apparel' => __( 'Clothing & Accessories', 'thirstyaffiliates-pro' ),
                'Appliances' => __( 'Appliances', 'thirstyaffiliates-pro' ),
                'Automotive' => __( 'Automotive Parts & Accessories', 'thirstyaffiliates-pro' ),
                'Baby' => __( 'Baby', 'thirstyaffiliates-pro' ),
                'Beauty' => __( 'Beauty & Personal Care', 'thirstyaffiliates-pro' ),
                'Books' => __( 'Books', 'thirstyaffiliates-pro' ),
                'Classical' => __( 'Classical', 'thirstyaffiliates-pro' ),
                'Computers' => __( 'Computers', 'thirstyaffiliates-pro' ),
                'DigitalMusic' => __( 'Digital Music', 'thirstyaffiliates-pro' ),
                'Electronics' => __( 'Electronics', 'thirstyaffiliates-pro' ),
                'EverythingElse' => __( 'Everything Else', 'thirstyaffiliates-pro' ),
                'Fashion' => __( 'Clothing, Shoes & Jewelry', 'thirstyaffiliates-pro' ),
                'ForeignBooks' => __( 'Foreign Books', 'thirstyaffiliates-pro' ),
                'GardenAndOutdoor' => __( 'Garden & Outdoor', 'thirstyaffiliates-pro' ),
                'GiftCards' => __( 'Gift Cards', 'thirstyaffiliates-pro' ),
                'GroceryAndGourmetFood' => __( 'Grocery & Gourmet Food', 'thirstyaffiliates-pro' ),
                'Handmade' => __( 'Handmade', 'thirstyaffiliates-pro' ),
                'HealthPersonalCare' => __( 'Health, Household & Baby Care', 'thirstyaffiliates-pro' ),
                'HomeAndKitchen' => __( 'Home & Kitchen', 'thirstyaffiliates-pro' ),
                'Industrial' => __( 'Industrial & Scientific', 'thirstyaffiliates-pro' ),
                'Jewelry' => __( 'Jewelry', 'thirstyaffiliates-pro' ),
                'KindleStore' => __( 'Kindle Store', 'thirstyaffiliates-pro' ),
                'Lighting' => __( 'Lighting', 'thirstyaffiliates-pro' ),
                'Luggage' => __( 'Luggage & Travel Gear', 'thirstyaffiliates-pro' ),
                'LuxuryBeauty' => __( 'Luxury Beauty', 'thirstyaffiliates-pro' ),
                'Magazines' => __( 'Magazine Subscriptions', 'thirstyaffiliates-pro' ),
                'MobileApps' => __( 'Apps & Games', 'thirstyaffiliates-pro' ),
                'MoviesAndTV' => __( 'Movies & TV', 'thirstyaffiliates-pro' ),
                'Music' => __( 'CDs & Vinyl', 'thirstyaffiliates-pro' ),
                'MusicalInstruments' => __( 'Musical Instruments', 'thirstyaffiliates-pro' ),
                'OfficeProducts' => __( 'Office Products', 'thirstyaffiliates-pro' ),
                'PetSupplies' => __( 'Pet Supplies', 'thirstyaffiliates-pro' ),
                'Photo' => __( 'Camera & Photo', 'thirstyaffiliates-pro' ),
                'Shoes' => __( 'Shoes', 'thirstyaffiliates-pro' ),
                'Software' => __( 'Software', 'thirstyaffiliates-pro' ),
                'SportsAndOutdoors' => __( 'Sports & Outdoors', 'thirstyaffiliates-pro' ),
                'ToolsAndHomeImprovement' => __( 'Tools & Home Improvement', 'thirstyaffiliates-pro' ),
                'ToysAndGames' => __( 'Toys & Games', 'thirstyaffiliates-pro' ),
                'VHS' => __( 'VHS', 'thirstyaffiliates-pro' ),
                'VideoGames' => __( 'Video Games', 'thirstyaffiliates-pro' ),
                'Watches' => __( 'Watches', 'thirstyaffiliates-pro' ),
            ),
            'IN' => array(
                'All' => __( '-- All Departments --', 'thirstyaffiliates-pro' ),
                'Apparel' => __( 'Clothing & Accessories', 'thirstyaffiliates-pro' ),
                'Appliances' => __( 'Appliances', 'thirstyaffiliates-pro' ),
                'Automotive' => __( 'Automotive Parts & Accessories', 'thirstyaffiliates-pro' ),
                'Baby' => __( 'Baby', 'thirstyaffiliates-pro' ),
                'Beauty' => __( 'Beauty & Personal Care', 'thirstyaffiliates-pro' ),
                'Books' => __( 'Books', 'thirstyaffiliates-pro' ),
                'Collectibles' => __( 'Collectibles & Fine Art', 'thirstyaffiliates-pro' ),
                'Computers' => __( 'Computers', 'thirstyaffiliates-pro' ),
                'Electronics' => __( 'Electronics', 'thirstyaffiliates-pro' ),
                'EverythingElse' => __( 'Everything Else', 'thirstyaffiliates-pro' ),
                'Fashion' => __( 'Clothing, Shoes & Jewelry', 'thirstyaffiliates-pro' ),
                'Furniture' => __( 'Furniture', 'thirstyaffiliates-pro' ),
                'GardenAndOutdoor' => __( 'Garden & Outdoor', 'thirstyaffiliates-pro' ),
                'GiftCards' => __( 'Gift Cards', 'thirstyaffiliates-pro' ),
                'GroceryAndGourmetFood' => __( 'Grocery & Gourmet Food', 'thirstyaffiliates-pro' ),
                'HealthPersonalCare' => __( 'Health, Household & Baby Care', 'thirstyaffiliates-pro' ),
                'HomeAndKitchen' => __( 'Home & Kitchen', 'thirstyaffiliates-pro' ),
                'Industrial' => __( 'Industrial & Scientific', 'thirstyaffiliates-pro' ),
                'Jewelry' => __( 'Jewelry', 'thirstyaffiliates-pro' ),
                'KindleStore' => __( 'Kindle Store', 'thirstyaffiliates-pro' ),
                'Luggage' => __( 'Luggage & Travel Gear', 'thirstyaffiliates-pro' ),
                'LuxuryBeauty' => __( 'Luxury Beauty', 'thirstyaffiliates-pro' ),
                'MobileApps' => __( 'Apps & Games', 'thirstyaffiliates-pro' ),
                'MoviesAndTV' => __( 'Movies & TV', 'thirstyaffiliates-pro' ),
                'Music' => __( 'CDs & Vinyl', 'thirstyaffiliates-pro' ),
                'MusicalInstruments' => __( 'Musical Instruments', 'thirstyaffiliates-pro' ),
                'OfficeProducts' => __( 'Office Products', 'thirstyaffiliates-pro' ),
                'PetSupplies' => __( 'Pet Supplies', 'thirstyaffiliates-pro' ),
                'Shoes' => __( 'Shoes', 'thirstyaffiliates-pro' ),
                'Software' => __( 'Software', 'thirstyaffiliates-pro' ),
                'SportsAndOutdoors' => __( 'Sports & Outdoors', 'thirstyaffiliates-pro' ),
                'ToolsAndHomeImprovement' => __( 'Tools & Home Improvement', 'thirstyaffiliates-pro' ),
                'ToysAndGames' => __( 'Toys & Games', 'thirstyaffiliates-pro' ),
                'VideoGames' => __( 'Video Games', 'thirstyaffiliates-pro' ),
                'Watches' => __( 'Watches', 'thirstyaffiliates-pro' ),
            ),
            'IT' => array(
                'All' => __( '-- All Departments --', 'thirstyaffiliates-pro' ),
                'Apparel' => __( 'Clothing & Accessories', 'thirstyaffiliates-pro' ),
                'Appliances' => __( 'Appliances', 'thirstyaffiliates-pro' ),
                'Automotive' => __( 'Automotive Parts & Accessories', 'thirstyaffiliates-pro' ),
                'Baby' => __( 'Baby', 'thirstyaffiliates-pro' ),
                'Beauty' => __( 'Beauty & Personal Care', 'thirstyaffiliates-pro' ),
                'Books' => __( 'Books', 'thirstyaffiliates-pro' ),
                'Computers' => __( 'Computers', 'thirstyaffiliates-pro' ),
                'DigitalMusic' => __( 'Digital Music', 'thirstyaffiliates-pro' ),
                'Electronics' => __( 'Electronics', 'thirstyaffiliates-pro' ),
                'EverythingElse' => __( 'Everything Else', 'thirstyaffiliates-pro' ),
                'Fashion' => __( 'Clothing, Shoes & Jewelry', 'thirstyaffiliates-pro' ),
                'ForeignBooks' => __( 'Foreign Books', 'thirstyaffiliates-pro' ),
                'GardenAndOutdoor' => __( 'Garden & Outdoor', 'thirstyaffiliates-pro' ),
                'GiftCards' => __( 'Gift Cards', 'thirstyaffiliates-pro' ),
                'GroceryAndGourmetFood' => __( 'Grocery & Gourmet Food', 'thirstyaffiliates-pro' ),
                'Handmade' => __( 'Handmade', 'thirstyaffiliates-pro' ),
                'HealthPersonalCare' => __( 'Health, Household & Baby Care', 'thirstyaffiliates-pro' ),
                'HomeAndKitchen' => __( 'Home & Kitchen', 'thirstyaffiliates-pro' ),
                'Industrial' => __( 'Industrial & Scientific', 'thirstyaffiliates-pro' ),
                'Jewelry' => __( 'Jewelry', 'thirstyaffiliates-pro' ),
                'KindleStore' => __( 'Kindle Store', 'thirstyaffiliates-pro' ),
                'Lighting' => __( 'Lighting', 'thirstyaffiliates-pro' ),
                'Luggage' => __( 'Luggage & Travel Gear', 'thirstyaffiliates-pro' ),
                'MobileApps' => __( 'Apps & Games', 'thirstyaffiliates-pro' ),
                'MoviesAndTV' => __( 'Movies & TV', 'thirstyaffiliates-pro' ),
                'Music' => __( 'CDs & Vinyl', 'thirstyaffiliates-pro' ),
                'MusicalInstruments' => __( 'Musical Instruments', 'thirstyaffiliates-pro' ),
                'OfficeProducts' => __( 'Office Products', 'thirstyaffiliates-pro' ),
                'PetSupplies' => __( 'Pet Supplies', 'thirstyaffiliates-pro' ),
                'Shoes' => __( 'Shoes', 'thirstyaffiliates-pro' ),
                'Software' => __( 'Software', 'thirstyaffiliates-pro' ),
                'SportsAndOutdoors' => __( 'Sports & Outdoors', 'thirstyaffiliates-pro' ),
                'ToolsAndHomeImprovement' => __( 'Tools & Home Improvement', 'thirstyaffiliates-pro' ),
                'ToysAndGames' => __( 'Toys & Games', 'thirstyaffiliates-pro' ),
                'VideoGames' => __( 'Video Games', 'thirstyaffiliates-pro' ),
                'Watches' => __( 'Watches', 'thirstyaffiliates-pro' ),
            ),
            'JP' => array(
                'All' => __( '-- All Departments --', 'thirstyaffiliates-pro' ),
                'AmazonVideo' => __( 'Prime Video', 'thirstyaffiliates-pro' ),
                'Apparel' => __( 'Clothing & Accessories', 'thirstyaffiliates-pro' ),
                'Appliances' => __( 'Appliances', 'thirstyaffiliates-pro' ),
                'Automotive' => __( 'Automotive Parts & Accessories', 'thirstyaffiliates-pro' ),
                'Baby' => __( 'Baby', 'thirstyaffiliates-pro' ),
                'Beauty' => __( 'Beauty & Personal Care', 'thirstyaffiliates-pro' ),
                'Books' => __( 'Books', 'thirstyaffiliates-pro' ),
                'Classical' => __( 'Classical', 'thirstyaffiliates-pro' ),
                'Computers' => __( 'Computers', 'thirstyaffiliates-pro' ),
                'CreditCards' => __( 'Credit Cards', 'thirstyaffiliates-pro' ),
                'DigitalMusic' => __( 'Digital Music', 'thirstyaffiliates-pro' ),
                'Electronics' => __( 'Electronics', 'thirstyaffiliates-pro' ),
                'EverythingElse' => __( 'Everything Else', 'thirstyaffiliates-pro' ),
                'Fashion' => __( 'Clothing, Shoes & Jewelry', 'thirstyaffiliates-pro' ),
                'FashionBaby' => __( 'Clothing, Shoes & Jewelry Baby', 'thirstyaffiliates-pro' ),
                'FashionMen' => __( 'Clothing, Shoes & Jewelry Men', 'thirstyaffiliates-pro' ),
                'FashionWomen' => __( 'Clothing, Shoes & Jewelry Women', 'thirstyaffiliates-pro' ),
                'ForeignBooks' => __( 'Foreign Books', 'thirstyaffiliates-pro' ),
                'GiftCards' => __( 'Gift Cards', 'thirstyaffiliates-pro' ),
                'GroceryAndGourmetFood' => __( 'Grocery & Gourmet Food', 'thirstyaffiliates-pro' ),
                'HealthPersonalCare' => __( 'Health, Household & Baby Care', 'thirstyaffiliates-pro' ),
                'Hobbies' => __( 'Hobby', 'thirstyaffiliates-pro' ),
                'HomeAndKitchen' => __( 'Home & Kitchen', 'thirstyaffiliates-pro' ),
                'Industrial' => __( 'Industrial & Scientific', 'thirstyaffiliates-pro' ),
                'Jewelry' => __( 'Jewelry', 'thirstyaffiliates-pro' ),
                'KindleStore' => __( 'Kindle Store', 'thirstyaffiliates-pro' ),
                'MobileApps' => __( 'Apps & Games', 'thirstyaffiliates-pro' ),
                'MoviesAndTV' => __( 'Movies & TV', 'thirstyaffiliates-pro' ),
                'Music' => __( 'CDs & Vinyl', 'thirstyaffiliates-pro' ),
                'MusicalInstruments' => __( 'Musical Instruments', 'thirstyaffiliates-pro' ),
                'OfficeProducts' => __( 'Office Products', 'thirstyaffiliates-pro' ),
                'PetSupplies' => __( 'Pet Supplies', 'thirstyaffiliates-pro' ),
                'Shoes' => __( 'Shoes', 'thirstyaffiliates-pro' ),
                'Software' => __( 'Software', 'thirstyaffiliates-pro' ),
                'SportsAndOutdoors' => __( 'Sports & Outdoors', 'thirstyaffiliates-pro' ),
                'ToolsAndHomeImprovement' => __( 'Tools & Home Improvement', 'thirstyaffiliates-pro' ),
                'Toys' => __( 'Toys', 'thirstyaffiliates-pro' ),
                'VideoGames' => __( 'Video Games', 'thirstyaffiliates-pro' ),
                'Watches' => __( 'Watches', 'thirstyaffiliates-pro' ),
            ),
            'MX' => array(
                'All' => __( '-- All Departments --', 'thirstyaffiliates-pro' ),
                'Automotive' => __( 'Automotive Parts & Accessories', 'thirstyaffiliates-pro' ),
                'Baby' => __( 'Baby', 'thirstyaffiliates-pro' ),
                'Books' => __( 'Books', 'thirstyaffiliates-pro' ),
                'Electronics' => __( 'Electronics', 'thirstyaffiliates-pro' ),
                'Fashion' => __( 'Clothing, Shoes & Jewelry', 'thirstyaffiliates-pro' ),
                'FashionBaby' => __( 'Clothing, Shoes & Jewelry Baby', 'thirstyaffiliates-pro' ),
                'FashionBoys' => __( 'Clothing, Shoes & Jewelry Boys', 'thirstyaffiliates-pro' ),
                'FashionGirls' => __( 'Clothing, Shoes & Jewelry Girls', 'thirstyaffiliates-pro' ),
                'FashionMen' => __( 'Clothing, Shoes & Jewelry Men', 'thirstyaffiliates-pro' ),
                'FashionWomen' => __( 'Clothing, Shoes & Jewelry Women', 'thirstyaffiliates-pro' ),
                'GroceryAndGourmetFood' => __( 'Grocery & Gourmet Food', 'thirstyaffiliates-pro' ),
                'Handmade' => __( 'Handmade', 'thirstyaffiliates-pro' ),
                'HealthPersonalCare' => __( 'Health, Household & Baby Care', 'thirstyaffiliates-pro' ),
                'HomeAndKitchen' => __( 'Home & Kitchen', 'thirstyaffiliates-pro' ),
                'IndustrialAndScientific' => __( 'Industrial & Scientific', 'thirstyaffiliates-pro' ),
                'KindleStore' => __( 'Kindle Store', 'thirstyaffiliates-pro' ),
                'MoviesAndTV' => __( 'Movies & TV', 'thirstyaffiliates-pro' ),
                'Music' => __( 'CDs & Vinyl', 'thirstyaffiliates-pro' ),
                'MusicalInstruments' => __( 'Musical Instruments', 'thirstyaffiliates-pro' ),
                'OfficeProducts' => __( 'Office Products', 'thirstyaffiliates-pro' ),
                'PetSupplies' => __( 'Pet Supplies', 'thirstyaffiliates-pro' ),
                'Software' => __( 'Software', 'thirstyaffiliates-pro' ),
                'SportsAndOutdoors' => __( 'Sports & Outdoors', 'thirstyaffiliates-pro' ),
                'ToolsAndHomeImprovement' => __( 'Tools & Home Improvement', 'thirstyaffiliates-pro' ),
                'ToysAndGames' => __( 'Toys & Games', 'thirstyaffiliates-pro' ),
                'VideoGames' => __( 'Video Games', 'thirstyaffiliates-pro' ),
                'Watches' => __( 'Watches', 'thirstyaffiliates-pro' ),
            ),
            'NL' => array(
                'All' => __( '-- All Departments --', 'thirstyaffiliates-pro' ),
                'Automotive' => __( 'Automotive Parts & Accessories', 'thirstyaffiliates-pro' ),
                'Baby' => __( 'Baby', 'thirstyaffiliates-pro' ),
                'Beauty' => __( 'Beauty & Personal Care', 'thirstyaffiliates-pro' ),
                'Books' => __( 'Books', 'thirstyaffiliates-pro' ),
                'Electronics' => __( 'Electronics', 'thirstyaffiliates-pro' ),
                'EverythingElse' => __( 'Everything Else', 'thirstyaffiliates-pro' ),
                'Fashion' => __( 'Clothing, Shoes & Jewelry', 'thirstyaffiliates-pro' ),
                'GardenAndOutdoor' => __( 'Garden & Outdoor', 'thirstyaffiliates-pro' ),
                'GiftCards' => __( 'Gift Cards', 'thirstyaffiliates-pro' ),
                'GroceryAndGourmetFood' => __( 'Grocery & Gourmet Food', 'thirstyaffiliates-pro' ),
                'HealthPersonalCare' => __( 'Health, Household & Baby Care', 'thirstyaffiliates-pro' ),
                'HomeAndKitchen' => __( 'Home & Kitchen', 'thirstyaffiliates-pro' ),
                'Industrial' => __( 'Industrial & Scientific', 'thirstyaffiliates-pro' ),
                'KindleStore' => __( 'Kindle Store', 'thirstyaffiliates-pro' ),
                'MoviesAndTV' => __( 'Movies & TV', 'thirstyaffiliates-pro' ),
                'Music' => __( 'CDs & Vinyl', 'thirstyaffiliates-pro' ),
                'MusicalInstruments' => __( 'Musical Instruments', 'thirstyaffiliates-pro' ),
                'OfficeProducts' => __( 'Office Products', 'thirstyaffiliates-pro' ),
                'PetSupplies' => __( 'Pet Supplies', 'thirstyaffiliates-pro' ),
                'Software' => __( 'Software', 'thirstyaffiliates-pro' ),
                'SportsAndOutdoors' => __( 'Sports & Outdoors', 'thirstyaffiliates-pro' ),
                'ToolsAndHomeImprovement' => __( 'Tools & Home Improvement', 'thirstyaffiliates-pro' ),
                'ToysAndGames' => __( 'Toys & Games', 'thirstyaffiliates-pro' ),
                'VideoGames' => __( 'Video Games', 'thirstyaffiliates-pro' ),
            ),
            'PL' => array(
                'All' => __( '-- All Departments --', 'thirstyaffiliates-pro' ),
                'ArtsAndCrafts' => __( 'Arts, Crafts & Sewing', 'thirstyaffiliates-pro'),
                'Automotive' => __( 'Automotive Parts & Accessories', 'thirstyaffiliates-pro' ),
                'Baby' => __( 'Baby', 'thirstyaffiliates-pro' ),
                'Beauty' => __( 'Beauty & Personal Care', 'thirstyaffiliates-pro' ),
                'Books' => __( 'Books', 'thirstyaffiliates-pro' ),
                'Electronics' => __( 'Electronics', 'thirstyaffiliates-pro' ),
                'Fashion' => __( 'Clothing, Shoes & Jewelry', 'thirstyaffiliates-pro' ),
                'GardenAndOutdoor' => __( 'Garden & Outdoor', 'thirstyaffiliates-pro' ),
                'GiftCards' => __( 'Gift Cards', 'thirstyaffiliates-pro' ),
                'HealthPersonalCare' => __( 'Health, Household & Baby Care', 'thirstyaffiliates-pro' ),
                'HomeAndKitchen' => __( 'Home & Kitchen', 'thirstyaffiliates-pro' ),
                'Industrial' => __( 'Industrial & Scientific', 'thirstyaffiliates-pro' ),
                'MoviesAndTV' => __( 'Movies & TV', 'thirstyaffiliates-pro' ),
                'Music' => __( 'CDs & Vinyl', 'thirstyaffiliates-pro' ),
                'MusicalInstruments' => __( 'Musical Instruments', 'thirstyaffiliates-pro' ),
                'OfficeProducts' => __( 'Office Products', 'thirstyaffiliates-pro' ),
                'PetSupplies' => __( 'Pet Supplies', 'thirstyaffiliates-pro' ),
                'Software' => __( 'Software', 'thirstyaffiliates-pro' ),
                'SportsAndOutdoors' => __( 'Sports & Outdoors', 'thirstyaffiliates-pro' ),
                'ToolsAndHomeImprovement' => __( 'Tools & Home Improvement', 'thirstyaffiliates-pro' ),
                'ToysAndGames' => __( 'Toys & Games', 'thirstyaffiliates-pro' ),
                'VideoGames' => __( 'Video Games', 'thirstyaffiliates-pro' ),
            ),
            'SA' => array(
                'All' => __( '-- All Departments --', 'thirstyaffiliates-pro' ),
                'ArtsAndCrafts' => __( 'Arts, Crafts & Sewing', 'thirstyaffiliates-pro'),
                'Automotive' => __( 'Automotive Parts & Accessories', 'thirstyaffiliates-pro' ),
                'Baby' => __( 'Baby', 'thirstyaffiliates-pro' ),
                'Beauty' => __( 'Beauty & Personal Care', 'thirstyaffiliates-pro' ),
                'Books' => __( 'Books', 'thirstyaffiliates-pro' ),
                'Computers' => __( 'Computers', 'thirstyaffiliates-pro' ),
                'Electronics' => __( 'Electronics', 'thirstyaffiliates-pro' ),
                'Fashion' => __( 'Clothing, Shoes & Jewelry', 'thirstyaffiliates-pro' ),
                'GardenAndOutdoor' => __( 'Garden & Outdoor', 'thirstyaffiliates-pro' ),
                'GiftCards' => __( 'Gift Cards', 'thirstyaffiliates-pro' ),
                'GroceryAndGourmetFood' => __( 'Grocery & Gourmet Food', 'thirstyaffiliates-pro' ),
                'HealthPersonalCare' => __( 'Health, Household & Baby Care', 'thirstyaffiliates-pro' ),
                'HomeAndKitchen' => __( 'Home & Kitchen', 'thirstyaffiliates-pro' ),
                'Industrial' => __( 'Industrial & Scientific', 'thirstyaffiliates-pro' ),
                'KindleStore' => __( 'Kindle Store', 'thirstyaffiliates-pro' ),
                'Miscellaneous' => __( 'Everything Else', 'thirstyaffiliates-pro' ),
                'MoviesAndTV' => __( 'Movies & TV', 'thirstyaffiliates-pro' ),
                'Music' => __( 'CDs & Vinyl', 'thirstyaffiliates-pro' ),
                'MusicalInstruments' => __( 'Musical Instruments', 'thirstyaffiliates-pro' ),
                'OfficeProducts' => __( 'Office Products', 'thirstyaffiliates-pro' ),
                'PetSupplies' => __( 'Pet Supplies', 'thirstyaffiliates-pro' ),
                'Software' => __( 'Software', 'thirstyaffiliates-pro' ),
                'SportsAndOutdoors' => __( 'Sports & Outdoors', 'thirstyaffiliates-pro' ),
                'ToolsAndHomeImprovement' => __( 'Tools & Home Improvement', 'thirstyaffiliates-pro' ),
                'ToysAndGames' => __( 'Toys & Games', 'thirstyaffiliates-pro' ),
                'VideoGames' => __( 'Video Games', 'thirstyaffiliates-pro' ),
            ),
            'SG' => array(
                'All' => __( '-- All Departments --', 'thirstyaffiliates-pro' ),
                'Automotive' => __( 'Automotive Parts & Accessories', 'thirstyaffiliates-pro' ),
                'Baby' => __( 'Baby', 'thirstyaffiliates-pro' ),
                'Beauty' => __( 'Beauty & Personal Care', 'thirstyaffiliates-pro' ),
                'Computers' => __( 'Computers', 'thirstyaffiliates-pro' ),
                'Electronics' => __( 'Electronics', 'thirstyaffiliates-pro' ),
                'GroceryAndGourmetFood' => __( 'Grocery & Gourmet Food', 'thirstyaffiliates-pro' ),
                'HealthPersonalCare' => __( 'Health, Household & Baby Care', 'thirstyaffiliates-pro' ),
                'HomeAndKitchen' => __( 'Home & Kitchen', 'thirstyaffiliates-pro' ),
                'OfficeProducts' => __( 'Office Products', 'thirstyaffiliates-pro' ),
                'PetSupplies' => __( 'Pet Supplies', 'thirstyaffiliates-pro' ),
                'SportsAndOutdoors' => __( 'Sports & Outdoors', 'thirstyaffiliates-pro' ),
                'ToolsAndHomeImprovement' => __( 'Tools & Home Improvement', 'thirstyaffiliates-pro' ),
                'ToysAndGames' => __( 'Toys & Games', 'thirstyaffiliates-pro' ),
                'VideoGames' => __( 'Video Games', 'thirstyaffiliates-pro' ),
            ),
            'ES' => array(
                'All' => __( '-- All Departments --', 'thirstyaffiliates-pro' ),
                'Apparel' => __( '  Clothing & Accessories', 'thirstyaffiliates-pro' ),
                'Appliances' => __( 'Appliances', 'thirstyaffiliates-pro' ),
                'Automotive' => __( 'Automotive Parts & Accessories', 'thirstyaffiliates-pro' ),
                'Baby' => __( 'Baby', 'thirstyaffiliates-pro' ),
                'Beauty' => __( 'Beauty & Personal Care', 'thirstyaffiliates-pro' ),
                'Books' => __( 'Books', 'thirstyaffiliates-pro' ),
                'Computers' => __( 'Computers', 'thirstyaffiliates-pro' ),
                'DigitalMusic' => __( 'Digital Music', 'thirstyaffiliates-pro' ),
                'Electronics' => __( 'Electronics', 'thirstyaffiliates-pro' ),
                'EverythingElse' => __( 'Everything Else', 'thirstyaffiliates-pro' ),
                'Fashion' => __( 'Clothing, Shoes & Jewelry', 'thirstyaffiliates-pro' ),
                'ForeignBooks' => __( 'Foreign Books', 'thirstyaffiliates-pro' ),
                'GardenAndOutdoor' => __( 'Garden & Outdoor', 'thirstyaffiliates-pro' ),
                'GiftCards' => __( 'Gift Cards', 'thirstyaffiliates-pro' ),
                'GroceryAndGourmetFood' => __( 'Grocery & Gourmet Food', 'thirstyaffiliates-pro' ),
                'Handmade' => __( 'Handmade', 'thirstyaffiliates-pro' ),
                'HealthPersonalCare' => __( 'Health, Household & Baby Care', 'thirstyaffiliates-pro' ),
                'HomeAndKitchen' => __( 'Home & Kitchen', 'thirstyaffiliates-pro' ),
                'Industrial' => __( 'Industrial & Scientific', 'thirstyaffiliates-pro' ),
                'Jewelry' => __( 'Jewelry', 'thirstyaffiliates-pro' ),
                'KindleStore' => __( 'Kindle Store', 'thirstyaffiliates-pro' ),
                'Lighting' => __( 'Lighting', 'thirstyaffiliates-pro' ),
                'Luggage' => __( 'Luggage & Travel Gear', 'thirstyaffiliates-pro' ),
                'MobileApps' => __( 'Apps & Games', 'thirstyaffiliates-pro' ),
                'MoviesAndTV' => __( 'Movies & TV', 'thirstyaffiliates-pro' ),
                'Music' => __( 'CDs & Vinyl', 'thirstyaffiliates-pro' ),
                'MusicalInstruments' => __( 'Musical Instruments', 'thirstyaffiliates-pro' ),
                'OfficeProducts' => __( 'Office Products', 'thirstyaffiliates-pro' ),
                'PetSupplies' => __( 'Pet Supplies', 'thirstyaffiliates-pro' ),
                'Shoes' => __( 'Shoes', 'thirstyaffiliates-pro' ),
                'Software' => __( 'Software', 'thirstyaffiliates-pro' ),
                'SportsAndOutdoors' => __( 'Sports & Outdoors', 'thirstyaffiliates-pro' ),
                'ToolsAndHomeImprovement' => __( 'Tools & Home Improvement', 'thirstyaffiliates-pro' ),
                'ToysAndGames' => __( 'Toys & Games', 'thirstyaffiliates-pro' ),
                'Vehicles' => __( 'Car Rentals', 'thirstyaffiliates-pro' ),
                'VideoGames' => __( 'Video Games', 'thirstyaffiliates-pro' ),
                'Watches' => __( 'Watches', 'thirstyaffiliates-pro' ),
            ),
            'SE' => array(
                'All' => __( '-- All Departments --', 'thirstyaffiliates-pro' ),
                'Automotive' => __( 'Automotive Parts & Accessories', 'thirstyaffiliates-pro' ),
                'Baby' => __( 'Baby', 'thirstyaffiliates-pro' ),
                'Beauty' => __( 'Beauty & Personal Care', 'thirstyaffiliates-pro' ),
                'Books' => __( 'Books', 'thirstyaffiliates-pro' ),
                'Electronics' => __( 'Electronics', 'thirstyaffiliates-pro' ),
                'Fashion' => __( 'Clothing, Shoes & Jewelry', 'thirstyaffiliates-pro' ),
                'GroceryAndGourmetFood' => __( 'Grocery & Gourmet Food', 'thirstyaffiliates-pro' ),
                'HealthPersonalCare' => __( 'Health, Household & Baby Care', 'thirstyaffiliates-pro' ),
                'HomeAndKitchen' => __( 'Home & Kitchen', 'thirstyaffiliates-pro' ),
                'MoviesAndTV' => __( 'Movies & TV', 'thirstyaffiliates-pro' ),
                'Music' => __( 'CDs & Vinyl', 'thirstyaffiliates-pro' ),
                'OfficeProducts' => __( 'Office Products', 'thirstyaffiliates-pro' ),
                'PetSupplies' => __( 'Pet Supplies', 'thirstyaffiliates-pro' ),
                'SportsAndOutdoors' => __( 'Sports & Outdoors', 'thirstyaffiliates-pro' ),
                'ToolsAndHomeImprovement' => __( 'Tools & Home Improvement', 'thirstyaffiliates-pro' ),
                'ToysAndGames' => __( 'Toys & Games', 'thirstyaffiliates-pro' ),
                'VideoGames' => __( 'Video Games', 'thirstyaffiliates-pro' ),
            ),
            'TR' => array(
                'All' => __( '-- All Departments --', 'thirstyaffiliates-pro' ),
                'Baby' => __( 'Baby', 'thirstyaffiliates-pro' ),
                'Books' => __( 'Books', 'thirstyaffiliates-pro' ),
                'Computers' => __( 'Computers', 'thirstyaffiliates-pro' ),
                'Electronics' => __( 'Electronics', 'thirstyaffiliates-pro' ),
                'EverythingElse' => __( 'Everything Else', 'thirstyaffiliates-pro' ),
                'Fashion' => __( 'Clothing, Shoes & Jewelry', 'thirstyaffiliates-pro' ),
                'HomeAndKitchen' => __( 'Home & Kitchen', 'thirstyaffiliates-pro' ),
                'OfficeProducts' => __( 'Office Products', 'thirstyaffiliates-pro' ),
                'SportsAndOutdoors' => __( 'Sports & Outdoors', 'thirstyaffiliates-pro' ),
                'ToolsAndHomeImprovement' => __( 'Tools & Home Improvement', 'thirstyaffiliates-pro' ),
                'ToysAndGames' => __( 'Toys & Games', 'thirstyaffiliates-pro' ),
                'VideoGames' => __( 'Video Games', 'thirstyaffiliates-pro' ),
            ),
            'AE' => array(
                'All' => __( '-- All Departments --', 'thirstyaffiliates-pro'),
                'Appliances' => __( 'Appliances', 'thirstyaffiliates-pro'),
                'ArtsAndCrafts' => __( 'Arts, Crafts & Sewing', 'thirstyaffiliates-pro'),
                'Automotive' => __( 'Automotive Parts & Accessories', 'thirstyaffiliates-pro'),
                'Baby' => __( 'Baby', 'thirstyaffiliates-pro'),
                'Beauty' => __( 'Beauty & Personal Care', 'thirstyaffiliates-pro'),
                'Books' => __( 'Books', 'thirstyaffiliates-pro'),
                'Computers' => __( 'Computers', 'thirstyaffiliates-pro'),
                'Electronics' => __( 'Electronics', 'thirstyaffiliates-pro'),
                'EverythingElse' => __( 'Everything Else', 'thirstyaffiliates-pro'),
                'Fashion' => __( 'Clothing, Shoes & Jewelry', 'thirstyaffiliates-pro'),
                'GardenAndOutdoor' => __( 'Home & Garden', 'thirstyaffiliates-pro'),
                'GroceryAndGourmetFood' => __( 'Grocery & Gourmet Food', 'thirstyaffiliates-pro'),
                'HealthPersonalCare' => __( 'Health, Household & Baby Care', 'thirstyaffiliates-pro'),
                'HomeAndKitchen' => __( 'Home & Kitchen', 'thirstyaffiliates-pro'),
                'Industrial' => __( 'Industrial & Scientific', 'thirstyaffiliates-pro'),
                'Lighting' => __( 'Lighting', 'thirstyaffiliates-pro'),
                'MusicalInstruments' => __( 'Musical Instruments', 'thirstyaffiliates-pro'),
                'OfficeProducts' => __( 'Office Products', 'thirstyaffiliates-pro'),
                'PetSupplies' => __( 'Pet Supplies', 'thirstyaffiliates-pro'),
                'Software' => __( 'Software', 'thirstyaffiliates-pro'),
                'SportsAndOutdoors' => __( 'Sports', 'thirstyaffiliates-pro'),
                'ToolsAndHomeImprovement' => __( 'Tools & Home Improvement', 'thirstyaffiliates-pro'),
                'ToysAndGames' => __( 'Toys & Games', 'thirstyaffiliates-pro'),
                'VideoGames' => __( 'Video Games', 'thirstyaffiliates-pro'),
            ),
            'UK' => array(
                'All' => __( '-- All Departments --', 'thirstyaffiliates-pro' ),
                'AmazonVideo' => __( 'Amazon Video', 'thirstyaffiliates-pro' ),
                'Apparel' => __( 'Clothing', 'thirstyaffiliates-pro' ),
                'Appliances' => __( 'Large Appliances', 'thirstyaffiliates-pro' ),
                'Automotive' => __( 'Car & Motorbike', 'thirstyaffiliates-pro' ),
                'Baby' => __( 'Baby', 'thirstyaffiliates-pro' ),
                'Beauty' => __( 'Beauty', 'thirstyaffiliates-pro' ),
                'Books' => __( 'Books', 'thirstyaffiliates-pro' ),
                'Classical' => __( 'Classical Music', 'thirstyaffiliates-pro' ),
                'Computers' => __( 'Computers & Accessories', 'thirstyaffiliates-pro' ),
                'DigitalMusic' => __( 'Digital Music', 'thirstyaffiliates-pro' ),
                'Electronics' => __( 'Electronics & Photo', 'thirstyaffiliates-pro' ),
                'EverythingElse' => __( 'Everything Else', 'thirstyaffiliates-pro' ),
                'Fashion' => __( 'Fashion', 'thirstyaffiliates-pro' ),
                'GardenAndOutdoor' => __( 'Garden & Outdoors', 'thirstyaffiliates-pro' ),
                'GiftCards' => __( 'Gift Cards', 'thirstyaffiliates-pro' ),
                'GroceryAndGourmetFood' => __( 'Grocery', 'thirstyaffiliates-pro' ),
                'Handmade' => __( 'Handmade', 'thirstyaffiliates-pro' ),
                'HealthPersonalCare' => __( 'Health & Personal Care', 'thirstyaffiliates-pro' ),
                'HomeAndKitchen' => __( 'Home & Kitchen', 'thirstyaffiliates-pro' ),
                'Industrial' => __( 'Industrial & Scientific', 'thirstyaffiliates-pro' ),
                'Jewelry' => __( 'Jewellery', 'thirstyaffiliates-pro' ),
                'KindleStore' => __( 'Kindle Store', 'thirstyaffiliates-pro' ),
                'Lighting' => __( 'Lighting', 'thirstyaffiliates-pro' ),
                'Luggage' => __( 'Luggage', 'thirstyaffiliates-pro' ),
                'LuxuryBeauty' => __( 'Luxury Beauty', 'thirstyaffiliates-pro' ),
                'MobileApps' => __( 'Apps & Games', 'thirstyaffiliates-pro' ),
                'MoviesAndTV' => __( 'DVD & Blu-ray', 'thirstyaffiliates-pro' ),
                'Music' => __( 'CDs & Vinyl', 'thirstyaffiliates-pro' ),
                'MusicalInstruments' => __( 'Musical Instruments & DJ', 'thirstyaffiliates-pro' ),
                'OfficeProducts' => __( 'Stationery & Office Supplies', 'thirstyaffiliates-pro' ),
                'PetSupplies' => __( 'Pet Supplies', 'thirstyaffiliates-pro' ),
                'Shoes' => __( 'Shoes & Bags', 'thirstyaffiliates-pro' ),
                'Software' => __( 'Software', 'thirstyaffiliates-pro' ),
                'SportsAndOutdoors' => __( 'Sports & Outdoors', 'thirstyaffiliates-pro' ),
                'ToolsAndHomeImprovement' => __( 'DIY & Tools', 'thirstyaffiliates-pro' ),
                'ToysAndGames' => __( 'Toys & Games', 'thirstyaffiliates-pro' ),
                'VHS' => __( 'VHS', 'thirstyaffiliates-pro' ),
                'VideoGames' => __( 'PC & Video Games', 'thirstyaffiliates-pro' ),
                'Watches' => __( 'Watches', 'thirstyaffiliates-pro' ),
            ),
            'US' => array(
                'All' => __( '-- All Departments --', 'thirstyaffiliates-pro' ),
                'AmazonVideo' => __( 'Prime Video', 'thirstyaffiliates-pro' ),
                'Apparel' => __( 'Clothing & Accessories', 'thirstyaffiliates-pro' ),
                'Appliances' => __( 'Appliances', 'thirstyaffiliates-pro' ),
                'ArtsAndCrafts' => __( 'Arts, Crafts & Sewing', 'thirstyaffiliates-pro' ),
                'Automotive' => __( 'Automotive Parts & Accessories', 'thirstyaffiliates-pro' ),
                'Baby' => __( 'Baby', 'thirstyaffiliates-pro' ),
                'Beauty' => __( 'Beauty & Personal Care', 'thirstyaffiliates-pro' ),
                'Books' => __( 'Books', 'thirstyaffiliates-pro' ),
                'Classical' => __( 'Classical', 'thirstyaffiliates-pro' ),
                'Collectibles' => __( 'Collectibles & Fine Art', 'thirstyaffiliates-pro' ),
                'Computers' => __( 'Computers', 'thirstyaffiliates-pro' ),
                'DigitalMusic' => __( 'Digital Music', 'thirstyaffiliates-pro' ),
                'DigitalEducationalResources' => __( 'Digital Educational Resources', 'thirstyaffiliates-pro' ),
                'Electronics' => __( 'Electronics', 'thirstyaffiliates-pro' ),
                'EverythingElse' => __( 'Everything Else', 'thirstyaffiliates-pro' ),
                'Fashion' => __( 'Clothing, Shoes & Jewelry', 'thirstyaffiliates-pro' ),
                'FashionBaby' => __( 'Clothing, Shoes & Jewelry Baby', 'thirstyaffiliates-pro' ),
                'FashionBoys' => __( 'Clothing, Shoes & Jewelry Boys', 'thirstyaffiliates-pro' ),
                'FashionGirls' => __( 'Clothing, Shoes & Jewelry Girls', 'thirstyaffiliates-pro' ),
                'FashionMen' => __( 'Clothing, Shoes & Jewelry Men', 'thirstyaffiliates-pro' ),
                'FashionWomen' => __( 'Clothing, Shoes & Jewelry Women', 'thirstyaffiliates-pro' ),
                'GardenAndOutdoor' => __( 'Garden & Outdoor', 'thirstyaffiliates-pro' ),
                'GiftCards' => __( 'Gift Cards', 'thirstyaffiliates-pro' ),
                'GroceryAndGourmetFood' => __( 'Grocery & Gourmet Food', 'thirstyaffiliates-pro' ),
                'Handmade' => __( 'Handmade', 'thirstyaffiliates-pro' ),
                'HealthPersonalCare' => __( 'Health, Household & Baby Care', 'thirstyaffiliates-pro' ),
                'HomeAndKitchen' => __( 'Home & Kitchen', 'thirstyaffiliates-pro' ),
                'Industrial' => __( 'Industrial & Scientific', 'thirstyaffiliates-pro' ),
                'Jewelry' => __( 'Jewelry', 'thirstyaffiliates-pro' ),
                'KindleStore' => __( 'Kindle Store', 'thirstyaffiliates-pro' ),
                'LocalServices' => __( 'Home & Business Services', 'thirstyaffiliates-pro' ),
                'Luggage' => __( 'Luggage & Travel Gear', 'thirstyaffiliates-pro' ),
                'LuxuryBeauty' => __( 'Luxury Beauty', 'thirstyaffiliates-pro' ),
                'Magazines' => __( 'Magazine Subscriptions', 'thirstyaffiliates-pro' ),
                'MobileAndAccessories' => __( 'Cell Phones & Accessories', 'thirstyaffiliates-pro' ),
                'MobileApps' => __( 'Apps & Games', 'thirstyaffiliates-pro' ),
                'MoviesAndTV' => __( 'Movies & TV', 'thirstyaffiliates-pro' ),
                'Music' => __( 'CDs & Vinyl', 'thirstyaffiliates-pro' ),
                'MusicalInstruments' => __( 'Musical Instruments', 'thirstyaffiliates-pro' ),
                'OfficeProducts' => __( 'Office Products', 'thirstyaffiliates-pro' ),
                'PetSupplies' => __( 'Pet Supplies', 'thirstyaffiliates-pro' ),
                'Photo' => __( 'Camera & Photo', 'thirstyaffiliates-pro' ),
                'Shoes' => __( 'Shoes', 'thirstyaffiliates-pro' ),
                'Software' => __( 'Software', 'thirstyaffiliates-pro' ),
                'SportsAndOutdoors' => __( 'Sports & Outdoors', 'thirstyaffiliates-pro' ),
                'ToolsAndHomeImprovement' => __( 'Tools & Home Improvement', 'thirstyaffiliates-pro' ),
                'ToysAndGames' => __( 'Toys & Games', 'thirstyaffiliates-pro' ),
                'VHS' => __( 'VHS', 'thirstyaffiliates-pro' ),
                'VideoGames' => __( 'Video Games', 'thirstyaffiliates-pro' ),
                'Watches' => __( 'Watches', 'thirstyaffiliates-pro' ),
            ),

        );

    }

    // Reference : https://webservices.amazon.com/paapi5/documentation/common-request-parameters.html#host-and-region
    public function AMAZON_SEARCH_ENDPOINTS() {

        return array(
            'AU' => 'webservices.amazon.com.au',
            'BR' => 'webservices.amazon.com.br',
            'CA' => 'webservices.amazon.ca',
            'FR' => 'webservices.amazon.fr',
            'DE' => 'webservices.amazon.de',
            'IN' => 'webservices.amazon.in',
            'IT' => 'webservices.amazon.it',
            'JP' => 'webservices.amazon.co.jp',
            'MX' => 'webservices.amazon.com.mx',
            'NL' => 'webservices.amazon.nl',
            'PL' => 'webservices.amazon.pl',
            'SA' => 'webservices.amazon.sa',
            'SG' => 'webservices.amazon.sg',
            'ES' => 'webservices.amazon.es',
            'SE' => 'webservices.amazon.se',
            'TR' => 'webservices.amazon.com.tr',
            'AE' => 'webservices.amazon.ae',
            'UK' => 'webservices.amazon.co.uk',
            'US' => 'webservices.amazon.com',
        );

    }

    // Reference : https://webservices.amazon.com/paapi5/documentation/common-request-parameters.html#host-and-region
    public function AMAZON_SEARCH_REGIONS() {

        return array(
            'AU' => 'us-west-2',
            'BR' => 'us-east-1',
            'CA' => 'us-east-1',
            'FR' => 'eu-west-1',
            'DE' => 'eu-west-1',
            'IN' => 'eu-west-1',
            'IT' => 'eu-west-1',
            'JP' => 'us-west-2',
            'MX' => 'us-east-1',
            'NL' => 'eu-west-1',
            'PL' => 'eu-west-1',
            'SA' => 'eu-west-1',
            'SG' => 'us-west-2',
            'ES' => 'eu-west-1',
            'SE' => 'eu-west-1',
            'TR' => 'eu-west-1',
            'AE' => 'eu-west-1',
            'UK' => 'eu-west-1',
            'US' => 'us-east-1',
        );

    }

    // Reference : https://webservices.amazon.com/paapi5/documentation/troubleshooting/error-messages.html
    public function AMAZON_API_CRITICAL_ERRORS() {

        return array(
            'AccessDenied',
            'AccessDeniedAwsUsers',
            'InvalidAssociate',
            'IncompleteSignature',
            'InvalidPartnerTag',
            'InvalidSignature',
            'TooManyRequests',
            'RequestExpired',
            'InvalidParameterValue',
            'MissingParameter',
            'UnknownOperation',
            'UnrecognizedClient',
        );

    }

    // HTAccess Module

    public function HTACCESS_FILE() {

        return ABSPATH . '/.htaccess';

    }

}
