jQuery( document ).ready( function ( $ ) {
    var $csv_upload_form = $( '#tap_upload_csv_form' );

    $csv_upload_form.on( 'submit', function ( e ) {
        e.preventDefault();

        // Make sure we aren't running this when there's no file uploaded.
        if ( '' === $( '#import' ).val() ) {
            return;
        }

        var tap_offset = 0;
        var tap_total = 0;
        var tap_total_successful_links = 0;
        var tap_total_failed_links = 0;
        var tap_override_links = $( '#override_links' ).prop( 'checked' );
        var tap_skip_escape = $( '#skip_escape' ).prop( 'checked' );

        var tap_form_data = new FormData();
        var tap_file_input = $( '#import' )[0];
        tap_form_data.append( 'import', tap_file_input.files[0] );
        tap_form_data.append( 'action', 'tap_import_csv' );
        tap_form_data.append( '_wpnonce', tap_import_export.import_nonce );
        tap_form_data.append( 'import_key', tap_import_export.import_key );
        tap_form_data.append( 'override_links', tap_override_links );
        tap_form_data.append( 'skip_escape', tap_skip_escape );

        // Clear form submission inputs.
        $( '#import' ).val( '' );
        $( '#override_links' ).prop( 'checked', false );
        $( '#skip_escape' ).prop( 'checked', false );

        // Clear previous import information and make sure import progress information is visible again.
        $( '#tap-import-successful-links' ).html( '' );
        $( '#tap-import-failed-links' ).html( '' );
        $( '#tap-import-successful-rows' ).val( '' );
        $( '#tap-import-failed-rows' ).val( '' );
        $( '#tap-import-progress .tap-import-progress-information' ).show();

        var tap_import_batch = function () {
            tap_form_data.set( 'offset', tap_offset );
            $( '#tap-import-progress' ).show();

            $.ajax( {
                type: 'POST',
                url: ajaxurl,
                data: tap_form_data,
                contentType: false,
                processData: false,
            } ).done( function ( res ) {
                if ( ! res.success ) {
                    $( '#tap-import-progress' ).hide();
                    alert( res.message );
                    return;
                }

                tap_offset = res.offset;
                tap_total = res.total;
                var tap_import_percent = Math.round( ( tap_offset / tap_total ) * 100 );
                tap_total_successful_links += res.total_successful_links;
                tap_total_failed_links += res.total_failed_links;

                $( '#tap-import-progress .tap-progress-bar' ).css( 'width', tap_import_percent + '%' ).text( tap_import_percent + '%' );

                $( '#tap-import-progress #tap-import-successful-links' ).text( wp.i18n.sprintf(
                    wp.i18n.__( '%1$s links imported successfully.', 'thirstyaffiliates-pro' ),
                    tap_total_successful_links
                ) );

                $( '#tap-import-progress #tap-import-failed-links' ).text( wp.i18n.sprintf(
                    wp.i18n.__( '%1$s links failed to import.', 'thirstyaffiliates-pro' ),
                    tap_total_failed_links
                ) );

                $.each( res.imported_links, function ( _, link ) {
                    var tap_import_message;
                    var tap_import_list_id;

                    if ( link.was_successful ) {
                        tap_import_message = wp.i18n.sprintf(
                            wp.i18n.__( 'Link: %1$s (%2$s) was imported successfully.', 'thirstyaffiliates-pro' ) + '\n',
                            link.name,
                            link.slug
                        );

                        tap_import_list_id = '#tap-import-successful-rows';
                    } else {
                        tap_import_message = wp.i18n.sprintf(
                            wp.i18n.__( 'Link: %1$s (%2$s) failed to import (Error: %3$s).', 'thirstyaffiliates-pro' ) + '\n',
                            link.name,
                            link.slug,
                            link.error_message
                        );

                        tap_import_list_id = '#tap-import-failed-rows'
                    }

                    $( tap_import_list_id ).val( function ( _, current_list ) {
                        return current_list + tap_import_message;
                    } );
                } );

                if ( tap_offset < tap_total ) {
                    // Import the next batch.
                    tap_import_batch();
                } else {
                    // Import is complete.
                    $( '#tap-import-progress .tap-progress-bar' ).css( 'width', '100%' ).text( res.message );

                    setTimeout( function () {
                        $( '#tap-import-progress .tap-import-progress-information' ).fadeOut();
                    }, 3000 );
                }
            } );
        }

        tap_import_batch();
    } );
} );