<?php

if ( ! defined( 'ABSPATH' ) ) {
exit; // Exit if accessed directly.
}

get_header();
?>
<?php if ( have_posts() ) : ?>
<div class="site-content">
	<div class="content-container">
		<div id="primary" class="content-area">
			<?php while ( have_posts() ) : ?>
			<?php the_post(); ?>
			<h2><?php the_title();?></h2>
			<p><?= get_the_excerpt();?></p>
			<a  href="<?= get_permalink();?>" class="btn btn-primary">Read More</a>
			<?php endwhile; ?>
			<?php
			// Previous/next page navigation.
			the_posts_pagination(
				array(
					'prev_text'          => __( 'Previous page', 'nwph' ),
					'next_text'          => __( 'Next page', 'nwph' ),
					'before_page_number' => '<span class="meta-nav screen-reader-text">' . __( 'Page', 'casinomaxius' ) . ' </span>',
				)
			);
			?>
		</div>
		<div id="secondary">
			<?php  get_sidebar();?>
		</div>
	</div>
</div>
<?php else : ?>
	<h1><?php esc_html_e( 'Nothing Found', 'casinomaxius' ); ?></h1>
<?php endif; ?>
<?php
get_footer();

?>