<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Comment Reply Script.
if ( comments_open() && get_option( 'thread_comments' ) ) {
	wp_enqueue_script( 'comment-reply' );
}
?>

<div class="comments-area-main">
    <div id="comments" class="comments-area">

	<?php if ( have_comments() ) : ?>
		<h4 >
			<?php
			$comments_number = get_comments_number();
			if ( '1' === $comments_number ) {
				printf( esc_html_x( '1 Comment', 'comments title') );
			} else {
				printf(
					esc_html( /* translators: 1: number of comments */
						_nx(
							'%1$s Comment',
							'%1$s Comments',
							$comments_number,
							'comments title',
							
						)
					),
					esc_html( number_format_i18n( $comments_number ) )
				);
			}
			?>
		</h4>
		</div>
		<?php the_comments_navigation(); ?>

		
			<?php
		$args = [
    'style'       => 'ol',
    'format'      => 'html5',
    'short_ping'  => true,
];

// Use our custom callback if it's available
if( function_exists( 'wpse_comment_callback' ) )
{
    $args['format'] = 'wpse';
    $args['callback'] = 'wpse_comment_callback';
}

wp_list_comments( $args );?>
	</div>

		<?php the_comments_navigation(); ?>

<?php endif; // Check for have_comments(). ?>
<div class="main-form mt-30">
	<?php
	// If comments are closed and there are comments, let's leave a little note, shall we?
	if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
		?>
		<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'casinoMaxius' ); ?></p>
	<?php endif; ?>

	<?php
		$commenter = wp_get_current_commenter();
		$req = get_option( 'require_name_email' );
		$aria_req = ( $req ? " aria-required='true'" : '' );
	comment_form(
	array(
		'fields' => apply_filters(
			'comment_form_default_fields', array(
		
		'author'=>'
		<div class="form-group">
		<input type="text"  placeholder="Name " id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="300"' . $aria_req . '/>
		</div>',
		
		'email'  => '<div class="form-group">
		<input id="email"   name="email" placeholder="Email " type="email" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="300"' . $aria_req . ' />
		</div>',
		'url'    => '<div class="col-md-4 mb-30">' .
		'<input id="url" name="url"  placeholder="Website " type="text" value="' . esc_attr( $commenter['comment_author_url'] ) . '" size="300" /> 
		</div>',
	
			) 
			),
			'comment_field' => '<div class="form-group "> ' .
		
			'<textarea id="comment" name="comment" cols="30" rows="3" placeholder="Message"  placeholder="Message" aria-required="true"></textarea>' .
			'</div>',
			'label_submit' => 'Submit',
		
		));
	?>
</div>
	
<!-- .comments-area -->
