<?php
if ( ! defined( 'ABSPATH' ) ) {
exit; // Exit if accessed directly.
}

$version_ = mt_rand(0,999999).'.'.mt_rand(0,999999).'.'.mt_rand(0,999999);
// add css and js

add_action( 'wp_enqueue_scripts', function() 
{
    $themeUrl = get_template_directory_uri();

    // add the style.css file to the html head
    wp_enqueue_style( 'font-Poppins-css', 'https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap',array(), mt_rand(0,999999) , 'all' );
     wp_enqueue_style( 'font-oswal-css', 'https://fonts.googleapis.com/css2?family=Oswald:wght@200;300;400;500;600;700&display=swap',array(), mt_rand(0,999999) , 'all' );
     wp_enqueue_style( 'font-ibm-css', 'https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;1,100;1,200;1,300;1,400;1,500;1,600;1,700&display=swap',array(), mt_rand(0,999999) , 'all' ); 
    wp_enqueue_style( 'font-Roboto-css', 'https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap',array(), mt_rand(0,999999) , 'all' );
    
    wp_enqueue_style( 'font-awesome-css', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css',array(), mt_rand(0,999999) , 'all' );

    wp_enqueue_style( 'bootstrap-style-css', 'https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css',array(), mt_rand(0,999999) , 'all' );
    
    wp_enqueue_style( 'cm-home-page-css', get_stylesheet_directory_uri().'/assets/css/home-page.css',array(), mt_rand(0, 9999) , 'all' );
    
    wp_enqueue_style( 'cm-header-footer-css', get_stylesheet_directory_uri().'/assets/css/header-footer.css',array(), mt_rand(0, 9999) , 'all' );
    // add javascript to the bottom of the theme

    wp_enqueue_script( 'casinoMaxius-jquery-js', 'https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.0/jquery.min.js', array(),  mt_rand(0, 9999), false );
     wp_enqueue_script( 'casinoMaxius-bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.min.js', array(),  mt_rand(0, 9999), false );

    wp_enqueue_script( 'casinoMaxius-header-footer-js', get_stylesheet_directory_uri() . '/assets/js/header-footer.js', array(), mt_rand(0, 9999), false );
 wp_enqueue_script( 'casinoMaxius-home-page-js', get_stylesheet_directory_uri() . '/assets/js/home-page.js', array(), mt_rand(0, 9999), false );
    
} );
// post shortcodes
include_once 'shortcodes/site-list.php';
include_once 'shortcodes/pros-cons.php';
// custom logo
function theme_support_options() {
    // Enable support for Post Thumbnails on posts and pages.
  add_theme_support( 'post-thumbnails' );
  $defaults = array(
 'flex-height' => false,
 'flex-width'  => false
);
  add_theme_support( 'custom-logo', $defaults );
}
function my_theme_setup(){
    add_theme_support('post-thumbnails','title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields','category','widgets' );
}

add_action('after_setup_theme', 'my_theme_setup');
// call the function in the hook
add_action( 'after_setup_theme', 'theme_support_options' );

function register_menu()
{
    register_nav_menus(array(
        'primary-menu'=>__('Primary Menu')
       
    ));
}
add_action('init','register_menu');
function link_menu()
{
    register_nav_menus(array(
       
        'footer-menu'=>__('Footer Menu')
    ));
}
add_action('init','link_menu');
add_filter('nav_menu_link_attributes','menu_link_a',10,4);
function menu_link_a($classes,$item,$args,$dept)
{
    {
        $classes[]="business_li_class";
        return $classes;
    }
    
}
function post_register_sidebars() {
    register_sidebar( array(
        'name' => 'Category Filter',
        'id' => 'cat_1',
       
    ) );
	
}
add_action( 'widgets_init', 'post_register_sidebars' );
function gt_get_post_view() {


    $count = get_post_meta( get_the_ID(), 'post_views_count', true );


    return "$count";


}


function gt_set_post_view() {


    $key = 'post_views_count';


    $post_id = get_the_ID();


    $count = (int) get_post_meta( $post_id, $key, true );


    $count++;


    update_post_meta( $post_id, $key, $count );


}


function gt_posts_column_views( $columns ) {


    $columns['post_views'] = 'Views';


    return $columns;


}


function gt_posts_custom_column_views( $column ) {


    if ( $column === 'post_views') {


        echo gt_get_post_view();


    }


}


add_filter( 'manage_posts_columns', 'gt_posts_column_views' );


add_action( 'manage_posts_custom_column', 'gt_posts_custom_column_views' );



add_action('init', 'add_posttype');
function add_posttype() 
{
	$labels = array(
		'name' => _x('Review Post', 'post type general name'),
		'singular_name' => _x('Review Post', 'post type singular name'),
		'add_new' => _x('Add New', 'Review Post'),
		'add_new_item' => __('Add New Review Post'),
		'edit_item' => __('Edit Review Post'),
		'new_item' => __('New Review Post'),
		'view_item' => __('View Review Post'),
		'search_items' => __('Search Review Post'),
		'not_found' =>  __('Nothing found'),
		'not_found_in_trash' => __('Nothing found in Trash'),
		'parent_item_colon' => ''
	);

	$args = array(
		'labels' => $labels,
		'public' => true,
		'publicly_queryable' => true,
		'show_ui' => true,
		'query_var' => true,
		'rewrite' => true,
		'capability_type' => 'post',
	
		'menu_position' => null,
		'show_in_rest' => true,
		 'has_archive'           => true,
        'show_in_rest'          => true,
        'hierarchical'          => true,
        'public'                => true,
		'supports' => array('title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'post-formats', 'custom-fields'),
		'taxonomies' => array( 'post_tag','offer_category'),
		
	  );
	  register_post_type( 'review-post' , $args );
	  
//     	$label = array(
// 		'name' => _x('Bonus', 'post type general name'),
// 		'singular_name' => _x('Bonus', 'post type singular name'),
// 		'add_new' => _x('Add New', 'Bonust'),
// 		'add_new_item' => __('Add New Bonus'),
// 		'edit_item' => __('Edit Bonus'),
// 		'new_item' => __('New Bonus'),
// 		'view_item' => __('View Bonus'),
// 		'search_items' => __('Search Bonus'),
// 		'not_found' =>  __('Nothing found'),
// 		'not_found_in_trash' => __('Nothing found in Trash'),
// 		'parent_item_colon' => ''
// 	);

// 	$arg = array(
// 		'labels' => $label,
// 		'public' => true,
// 		'publicly_queryable' => true,
// 		'show_ui' => true,
// 		'query_var' => true,
// 		'rewrite' => true,
// 		'capability_type' => 'post',
// 		'hierarchical' => false,
// 		'menu_position' => null,
// 		'show_in_rest' => true,
// 		'supports' => array('title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'post-formats', 'custom-fields' ),
//     	'taxonomies' => array('category', 'post_tag'),
// 		'has_archive' => true,
// 	  );
	

	//register_post_type( 'bonus' , $arg );
}

// add_filter('pre_get_posts', 'query_post_type');
// function query_post_type($query) {
//   if( is_category() ) {
//     $post_type = get_query_var('post_type');
//     if($post_type)
//         $post_type = $post_type;
//     else
//         $post_type = array('nav_menu_item', 'post', 'review-post'); // don't forget nav_menu_item to allow menus to work!
//     $query->set('post_type',$post_type);
//     return $query;
//     }
// }
add_action( 'init', 'build_taxonomies', 0 );
function build_taxonomies() {
    register_taxonomy( 'offer_category', 'review-post', array( 'hierarchical' => true, 'label' => 'Review Post Categories', 'query_var' => true, 'rewrite' => true ) );
}

// For Auto Search Post
add_action( 'wp_ajax_search_post',        'ja_ajax_search' );
add_action( 'wp_ajax_nopriv_search_post', 'ja_ajax_search' );

function ja_ajax_search() {

    $query = new WP_Query( array(
        'post_type'     => 'post',
        'post_status'   => 'publish',
        // 'nopaging'      => true,
        'posts_per_page'=> -1,
        'search_post_title'    => esc_attr( $_REQUEST['term'] ),
    ) );
    // echo '<pre>';
    // print_r($results1);

?>

<ul>
<?php

    if( $query->have_posts() ) :
        while( $query->have_posts() ): $query->the_post(); 
             // global $post;
           ?>
            <li><a href="<?php echo esc_url( get_permalink() ); ?>"><?php the_title();?></a>

        <?php endwhile;
        wp_reset_postdata();  
    else:
        ?>
        <li>No Posts Found</li>
        <?php
    endif;
?>
</ul>
<?php

    die();
}
add_action( 'pre_get_posts', 'wpse5477_pre_get_posts' );
 function wpse5477_pre_get_posts( $query )
 {
     if ( ! $query->is_main_query() || $query->is_admin() )
        return false; 
    if ( $query->is_category() ) {
       
        $query->set( 'posts_per_page',3);
     }
     return $query;
 }
/**
 * Fix pagination on archive pages
 */
function my_pagination_rewrite() {
     $categories = '(' . implode('|', array_map(function($category){return $category->slug;}, get_categories())) . ')';
     add_rewrite_rule($categories . '/page/?([0-9]{1,})/?$', 'index.php?category_name=$matches[1]&paged=$matches[2]', 'top');
 }
 add_action('init', 'my_pagination_rewrite');
function footer_custom($wp_customize)
{
    
    $wp_customize->add_section('footer_section',array(
        'title'=>'Footer Dynamic'
    ));
    $wp_customize->add_setting('footer_img_setting',array(
        'default'=>get_bloginfo('template_url').'/img/footer-logo.png'
    ));
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize ,'footer_img_control',array(
        'label'=>'Choose Image',
        'section'=>'footer_section',
        'settings'=>'footer_img_setting'
    )));
   
}
add_action('customize_register','footer_custom');



function set_my_comment_title( $defaults ) {

    $defaults['field']['author'] = '<div class="form-group col-md-4"><input id="author" name="author" class="form-control" placeholder="Name" required="required" type="text"></div>';
    $defaults['field']['email'] = '<div class="form-group col-md-4"><input id="email" name="email" class="form-control" placeholder="Email" required="required" type="text"></div>';
    $defaults['comment_field'] = '<div class="form-group "><textarea id="comment" name="comment" rows="3" class="form-control" placeholder="Message"></textarea></div>';
	  $defaults['title_reply'] = __( 'Leave a Comment' );  
    return $defaults;
}
add_filter( 'comment_form_defaults', 'set_my_comment_title' );
function wpse_comment_callback($comment, $args, $depth) {
$GLOBALS['comment'] = $comment;
?> 
<div class="comment-wapper-main">
 <div class="comment-user"> 
     <?php echo get_avatar( $comment, 61); ?>
 </div>
<div class="comment-detail">
    <?php if ($comment->comment_approved == '0') : ?>
        <em><?php esc_html_e('Your comment is awaiting moderation.','casinomaxius') ?></em>
         <br />
     <?php endif; ?>
	<div class="comment-flex">
		 <div class="user-name"><?php echo get_comment_author() ?></div>
		<div class="post-info">
             <ul>
                <li><?php echo get_comment_date();?></li>
<!--                 <li><a href="#"><i class="fa fa-reply"></i><?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))); ?></a></li> -->
            </ul>
        </div>
	</div>
   
        
        <p><?php comment_text() ;?></p>
                  
</div>
	
 </div>

<?php
 }
function social_page_custom($wp_customize_social){
    $wp_customize_social->add_section('casinoMaxius_social', array(
        'title'    => __( 'Social Media', 'casinoMaxius' ),
        'description'      => __( 'Add All Social Media Button Setting Here', 'casinoMaxius' ),
        
    ));
      //facebook
        $wp_customize_social->add_setting( 'casinoMaxius_facebook_url',
        array(
        'capability'     => 'edit_theme_options',
        'type'           => 'option',
        )
    );
    $wp_customize_social->add_control( 'casinoMaxius_facebook_url_control', 
        array(
            'type'        => 'text',
            'priority'    => 10,
            'section'     => 'casinoMaxius_social',
            'settings'    => 'casinoMaxius_facebook_url',
            'label'       => 'Facebook URL',
        ) 
    );
     //Twitter
        $wp_customize_social->add_setting( 'casinoMaxius_twitter_url',
        array(  
        'capability'     => 'edit_theme_options',
        'type'           => 'option',
        )
    );
    $wp_customize_social->add_control( 'casinoMaxius_twitter_url_control', 
        array(
            'type'        => 'text',
            'priority'    => 10,
            'section'     => 'casinoMaxius_social',
            'settings'    => 'casinoMaxius_twitter_url',
            'label'       => 'Twitter URL',
        ) 
    );
    //youtube
        $wp_customize_social->add_setting( 'casinoMaxius_youtube_url',
        array(  
        'capability'     => 'edit_theme_options',
        'type'           => 'option',
        )
    );
    $wp_customize_social->add_control( 'casinoMaxius_youtube_url_control', 
        array(
            'type'        => 'text',
            'priority'    => 10,
            'section'     => 'casinoMaxius_social',
            'settings'    => 'casinoMaxius_youtube_url',
            'label'       => 'Youtube URL',
        ) 
    );
    //telegram
    $wp_customize_social->add_setting( 'casinoMaxius_telegram_url',
        array(  
        'capability'     => 'edit_theme_options',
        'type'           => 'option',
        )
    );
    $wp_customize_social->add_control( 'casinoMaxius_telegram_url_control', 
        array(
            'type'        => 'text',
            'priority'    => 10,
            'section'     => 'casinoMaxius_social',
            'settings'    => 'casinoMaxius_telegram_url',
            'label'       => 'Telegram URL',
        ) 
    );
    //whatsapp
    $wp_customize_social->add_setting( 'casinoMaxius_whatsapp_url',
        array(  
        'capability'     => 'edit_theme_options',
        'type'           => 'option',
        )
    );
    $wp_customize_social->add_control( 'casinoMaxius_whatsapp_url_control', 
        array(
            'type'        => 'text',
            'priority'    => 10,
            'section'     => 'casinoMaxius_social',
            'settings'    => 'casinoMaxius_whatsapp_url',
            'label'       => 'WhatsApp URL',
        ) 
    );
    //other
        $wp_customize_social->add_setting( 'casinoMaxius_other_url',
        array(  
        'capability'     => 'edit_theme_options',
        'type'           => 'option',
        )
    );
    $wp_customize_social->add_control( 'casinoMaxius_other_url_control', 
        array(
            'type'        => 'text',
            'priority'    => 10,
            'section'     => 'casinoMaxius_social',
            'settings'    => 'casinoMaxius_other_url',
            'label'       => 'Reddit URL',
        ) 
    );
}
add_action("customize_register","social_page_custom");
function Bottom_footer_custom($wp_customize_social){
    $wp_customize_social->add_section('casinoMaxius_footer_bottom', array(
        'title'    => __( 'Footer Bottom Text', 'casinoMaxius' ),
        'description'      => __( 'Add Footer Bottom Setting Here', 'casinoMaxius' ),
        
    ));
     
        $wp_customize_social->add_setting( 'casinoMaxius_footer_text',
        array(
        'capability'     => 'edit_theme_options',
        'type'           => 'option',
        )
    );
    $wp_customize_social->add_control( 'casinoMaxius_footer_text_control', 
        array(
            'type'        => 'text',
            'priority'    => 10,
            'section'     => 'casinoMaxius_footer_bottom',
            'settings'    => 'casinoMaxius_footer_text',
            'label'       => 'Footer Bottom Text',
        ) 
    );
    
        $wp_customize_social->add_setting( 'casinoMaxius_button_text',
        array(  
        'capability'     => 'edit_theme_options',
        'type'           => 'option',
        )
    );
    $wp_customize_social->add_control( 'casinoMaxius_button_text_control', 
        array(
            'type'        => 'text',
            'priority'    => 10,
            'section'     => 'casinoMaxius_footer_bottom',
            'settings'    => 'casinoMaxius_button_text',
            'label'       => 'Footer Bottom Button Text',
        ) 
    );
      
        $wp_customize_social->add_setting( 'casinoMaxius_button_url',
        array(  
        'capability'     => 'edit_theme_options',
        'type'           => 'option',
        )
    );
    $wp_customize_social->add_control( 'casinoMaxius_button_url_control', 
        array(
            'type'        => 'text',
            'priority'    => 10,
            'section'     => 'casinoMaxius_footer_bottom',
            'settings'    => 'casinoMaxius_button_url',
            'label'       => 'Button URL',
        ) 
    );
   
}
add_action("customize_register","Bottom_footer_custom");
if( function_exists('acf_add_options_page') ) {
    
    acf_add_options_page(array(
        'page_title'    => 'Ad Banner',
        'menu_title'    => 'Ad Banner',
        'menu_slug'     => 'ad-banner-settings',
        'capability'    => 'edit_posts',
        'redirect'      => false
    ));

     acf_add_options_page(array(
        'page_title'    => 'CTA BUtton Text',
        'menu_title'    => 'CTA BUtton Text',
        'menu_slug'     => 'cta-bUtton-settings',
        'capability'    => 'edit_posts',
        'redirect'      => false
    ));
    acf_add_options_page(array(
        'page_title'    => 'Country Dropdown List',
        'menu_title'    => 'Country Dropdown List',
        'menu_slug'     => 'country-dropdown-settings',
        'capability'    => 'edit_posts',
        'redirect'      => false
    ));

}

function polylang_shortcode11() {
    ob_start();
    $languages = icl_get_languages();
    $current_lan = pll_current_language(); 
    foreach((array)$languages as $language):  
        if($language['language_code'] == $current_lan )   
        {       
?>
                
                    <a rel="alternate" hreflang="<?php echo $language['language_code']; ?>" href="<?php echo $language['url']; ?>">
                    <img src="<?php echo $language['country_flag_url']; ?>" alt="<?php echo $language['native_name']; ?>" title="<?php echo $language['native_name']; ?>" />
                    <span><?php echo $language['native_name']; ?>  </span>  
                    </a> 
             
<?php
}
        endforeach;
    return ob_get_clean();
    
}
add_shortcode( 'polylang_lan', 'polylang_shortcode11' );
function add_target_blank_to_language_links() {
    ?>
    <script>
    document.addEventListener("DOMContentLoaded", function() {
   
        var languageLinks = document.querySelectorAll('.lang-item a');
        
       
        languageLinks.forEach(function(link) {
            link.setAttribute('target', '_blank');
        });
    });
    </script>
    <?php
}
add_action('wp_footer', 'add_target_blank_to_language_links');


?>