<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<title><?php echo wp_title();?></title>
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
    <?php
	global $class;
	function create_menu($item, $class)
	{
		$link = $item->url;
		$title = $item->title;
		$id = $item->ID;
		if (property_exists($item, 'child')) :
			$children = $item->child; ?>
			<li class="main_li states-li">
				<a href="<?= $link; ?>" target="_blank"><?= $title; ?></a>
				 <ul class="sub_menu_ul">
				 	<?php
					foreach ($children as $child) :
						create_child_menu($child, $class);
					endforeach;
					?>
				</ul>
			</li>
		<?php else : ?>
			<li>
				<a href="<?= $link; ?>" target="_blank"><?= $title; ?></a>
			</li>
		<?php endif;
	}
	function create_child_menu($item)
	{
		$link = $item->url;
		$title = $item->title;
		$id = $item->ID;
		if (property_exists($item, 'child')) :
			$children = $item->child; ?>
			<li class="sub-menu">
				<a href="<?= $link; ?>" target="_blank"><span><?= $title; ?></span></a>
				<ul class="sub-menu-wapper">
				
					<?php
					foreach ($children as $child) :
						$link = $child->url;
						$title = $child->title; ?>
						<li >
							<a href="<?= $link; ?>" target="_blank"><span><?= $title; ?></span></a>
						</li>
					<?php endforeach; ?>
				</ul>
			</li>
		<?php else : ?>
			<li>
				<a href="<?= $link; ?>" target="_blank"><span><?= $title; ?></span></a>
			</li>
	<?php endif;
	} ?>
	<section id="h-home" class="h-home-wapper">
		<div class="h-header-main">
			<div class="container">
				<div class="h-header-nav">
					<div class="h-header-logo">
						<?php
						$current_lang = pll_current_language(); 
						if($current_lang=='en'){
							$home_url=site_url();
						}else{
							$home_url=site_url().'/'.$current_lang;
						}

    					$custom_logo_id = get_theme_mod( 'custom_logo' );
    					$logo = wp_get_attachment_image_src( $custom_logo_id , 'full' );
    					if ( has_custom_logo() ) 
							{
								?>
							            <a href="<?php echo $home_url;?>" target="_blank"><img src="<?php echo esc_url( $logo[0]); ?>" class="img-fluid" alt="logo"></a>
								<?php
							}
							else
							{
								echo '<h1>'. get_bloginfo( 'name' ) .'</h1>';
							}
					?>
						
					</div>
					<div class="h-header-menu">
						<div class="h-toggle-btn" id="h-toggle-btn">
							<div class="line-card one"></div>
							<div class="line-card two"></div>
							<div class="line-card three"></div>
						</div>
						<div class="h-main-menu" id="h-sidebar-wrapper">
							<ul><?php
							$menuLocations = get_nav_menu_locations();
							$menuID = $menuLocations['primary-menu'];
							$menuitems  = wp_get_nav_menu_items($menuID);
							function buildTree(array &$elements, $parentId = 0)
							{
								$branch = array();
								foreach ($elements as &$element) {
									if ($element->menu_item_parent == $parentId) {
										$children = buildTree($elements, $element->ID);
										if ($children) {
											$element->child = $children;
										}
										$element->has_children = 1;
										$branch[$element->ID] = $element;
										unset($element);
									}
								}
								return $branch;
							}
							$menuitems = buildTree($menuitems);
							foreach ($menuitems  as $item) {
								create_menu($item, $class);
							}?>
							<li class="main_li states-li cm-flag-dropdown">
								<?php 
								 $currentLang = pll_current_language('name');
								 $Langflag= pll_current_language('flag');
							 
								?>
								<a href="<?php echo $home_url;?>" class="cm-flag-dropdown__skeleton" target="_blank">
									<div class="cm-flag-dropdown__selected"><?php echo $Langflag; ?> <span><?php echo $currentLang ; ?></span></div>
									
								</a>
								<div class="cm-flag-dropdown__arrow">
									</div>
								<ul class="cm-flag-dropdown__options">
									<li>
										<div class="cm-input-serch">
											<input type="text" name="search" placeholder="search" id="languageSearch" autocomplete="off">
											<i class="fas fa-search"></i>
										</div>
										<div id="noCountryFound" style="display: none;">No country found...</div>
									</li>
									<?php 
									if(function_exists('pll_the_languages')){
										pll_the_languages( array( 
											'show_flags' => 1, 
											'show_names' => 1,
											'hide_current' => true 
										) );
									
									}?>
								</ul>
           					 </li>
								
							</ul>
						</div>
					</div>
                    <div class="h-header-social-icon-wapper">
                        <ul>
                        	<?php if(get_option('casinoMaxius_facebook_url')){
                        		echo '<li><a href="'.get_option('casinoMaxius_facebook_url').'" target="_blank"><i class="fab fa-facebook-f"></i></a></li>';
                        	} ?>
                        	<?php if(get_option('casinoMaxius_twitter_url')){
                        		echo '<li><a href="'.get_option('casinoMaxius_twitter_url').'" target="_blank"><i class="fab fa-twitter"></i></a></li>';
                        	} ?>
                        	<?php if(get_option('casinoMaxius_youtube_url')){
                        		echo '<li><a href="'.get_option('casinoMaxius_youtube_url').'" target="_blank"><i class="fab fa-youtube"></i></a></li>';
                        	} ?>
                        	<?php if(get_option('casinoMaxius_other_url')){
                        		echo '<li><a href="'.get_option('casinoMaxius_other_url').'" target="_blank"><i class="fab fa-reddit-alien"></i></a></li>';
                        	} ?>
							<?php if(get_option('casinoMaxius_telegram_url')){
                        		echo '<li><a href="'.get_option('casinoMaxius_telegram_url').'" target="_blank"><i class="fab fa-telegram"></i></a></li>';
                        	} ?>
							<?php if(get_option('casinoMaxius_whatsapp_url')){
                        		echo '<li><a href="'.get_option('casinoMaxius_whatsapp_url').'" target="_blank"><i class="fab fa-whatsapp"></i></a></li>';
                        	} ?>
                        </ul>
                    </div>
				</div>
			</div>
		</div>
	</section>