<?php
if (!defined('ABSPATH')) {
    die; // If this file is called directly, abort.
}
if (!class_exists('cm_pros_cons_Shortcode')) {

    class cm_pros_cons_Shortcode
    {

        function __construct()
        {
            add_shortcode('REVIEW_PROS_CONS', array($this, 'pros_cons_for_post'));
            add_action('wp_enqueue_scripts', array($this, 'add_style_script_for_pros_cons'));
        }
        function add_style_script_for_pros_cons()
        {
               wp_enqueue_style( 'cm-cta-pc-page-css', get_stylesheet_directory_uri().'/assets/css/cta-page.css',array(), mt_rand(0, 9999) , 'all' );
            
        }

        function pros_cons_for_post($attributes)
        {
            ob_start();
           
            global $post;
            $post_id=$post->ID;
           
            if (empty($attributes['id'])) {
                return 'Error';
            }
            $id = intval($attributes['id']);
            $counter = 0;            
            if (have_rows('blackjack_review_')):
                while (have_rows('blackjack_review_')):
                    the_row();
                    $counter++;
                    if ($counter == $id) {
            ?>
           
						<div class="our-score-wapper">
							<div class="our-score-top">
								<div class="our-score-top-left">
                                    <?php if(get_sub_field('rating',$post_id)){ ?>
									<h4><a ><?php echo get_sub_field('rating',$post_id);?></a></h4>
                                    <?php } ?>
									<p>Our Score</p>
								</div>
								<div class="our-score-top-right">
                                    <?php if(get_sub_field('review_title',$post_id)){ ?>
									<h3><?php echo get_sub_field('review_title',$post_id);?></h3>
                                    <?php } ?>
                                    <?php if(get_sub_field('review_detail',$post_id)){ ?>
									<p><?php echo get_sub_field('review_detail',$post_id); ?>
									</p>
                                    <?php } ?>
								</div>
							</div>
                            <?php 
                                $pros=get_sub_field('pros',$post_id);
                                $cons=get_sub_field('cons',$post_id);
                                if($pros || $cons){ 
                            ?>
							<div class="our-score-pros-cons-wapper">
								<div class="our-score-pros">
                                <?php if(get_sub_field('pros',$post_id)){ 
                                    $pros=get_sub_field('pros',$post_id);
                                    ?>
									<h3>Pros</h3>
									<ul>
                                        <?php foreach($pros as $bpros){ ?>
										<li><img src="<?php echo get_template_directory_uri() . '/assets/'?>img/Check cr-fr.svg" alt=""><?php echo $bpros['blackjack_pros']?></li>
										<?php } ?>
									</ul>
                                    <?php }?>
								</div>
								<div class="our-score-cons">
									
                                    <?php if(get_sub_field('cons',$post_id)){ 
                                    $cons=get_sub_field('cons',$post_id);
                                    ?>
                                    <h3>Cons</h3>
									<ul>
                                    <?php foreach(  $cons as $bcons){ ?>
										<li><img src="<?php echo get_template_directory_uri() . '/assets/'?>img/Remove cr-fr.svg" alt=""><?php echo $bcons['blackjack_cons']?></li>
									<?php } ?>
									</ul>
                                    <?php } ?>
								</div>

							</div>
                            <?php } ?>
							<div class="our-score-btn">
                            <?php if(get_sub_field('claim_url',$post_id)){  ?>
								<a href="<?php echo get_sub_field('claim_url',$post_id); ?>">
									<img src="<?php echo get_template_directory_uri() . '/assets/'?>img/material-symbols_check-circle-rounded.svg"> Claim </a>
							<?php } ?>
                            </div>
						</div>
                       
						<!-- Our Score End -->
            <?php
                }    endwhile; endif;
            return ob_get_clean();
        }
    }
}
if (class_exists('cm_pros_cons_Shortcode')) {
    $pc_shortcode = new cm_pros_cons_Shortcode();
}
?>