<?php
if (!defined('ABSPATH')) {
    die; // If this file is called directly, abort.
}
if (!class_exists('Blackjack_sites_Shortcode')) {

    class Blackjack_sites_Shortcode
    {

        function __construct()
        {
            add_shortcode('BLACKJACK_SITE', array($this, 'Blackjack_site_for_post'));
            add_action('wp_enqueue_scripts', array($this, 'add_style_script_for_blackjack'));
        }
        function add_style_script_for_blackjack()
        {
            wp_enqueue_style( 'cm-cta-shortcode-font1-css', 'https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;1,100;1,200;1,300;1,400;1,500;1,600;1,700&display=swap',array(), mt_rand(0, 9999) , 'all' );
            wp_enqueue_style( 'cm-cta-shortcode-font2-css', '"https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;1,100;1,200;1,300;1,400;1,500;1,600;1,700&family=Oswald:wght@200;300;400;500;600;700&display=swap',array(), mt_rand(0, 9999) , 'all' );
            wp_enqueue_style( 'cm-cta-shortcode-font3-css', 'https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap',array(), mt_rand(0, 9999) , 'all' );
            wp_enqueue_style( 'cm-cta-shortcode-font4-for-widget-css', 'https://fonts.googleapis.com/css2?family=DM+Sans:opsz,wght@9..40,400;9..40,700&display=swap',array(), mt_rand(0, 9999) , 'all' );
        
               wp_enqueue_style( 'cm-cta-shortcode-page-css', get_stylesheet_directory_uri().'/assets/css/cta-page.css',array(), mt_rand(0, 9999) , 'all' );
            
        }

        function Blackjack_site_for_post($attributes)
        {
            ob_start();
           
            global $post;
            $post_id=$post->ID;
           
            if (empty($attributes['id'])) {
                return 'Error';
            }
            $id = intval($attributes['id']);
            $counter = 0;            
            if (have_rows('best_blackjack_site_list')):
                while (have_rows('best_blackjack_site_list')):
                    the_row();
                    $counter++;
                    if ($counter == $id) {
            ?>
            <div class="cta-best-blackjack-site-wapper">
                <div class="cta-best-blackjack-site-titel">
                    <?php if(get_sub_field('blackjack_section_heading',$post_id)){ ?>
                        <h2><?=get_sub_field('blackjack_section_heading',$post_id); ?></h2>
                        <?php } ?>
                </div>
                <?php 
                            $count=0;
                            $sites = get_sub_field('best_blackjack_sites',$post_id);
                          
                            foreach ( $sites as $site) :
                                
                                    $count++;
                        ?>
							<div class="cta-best-blackjack-card-main">
								<div class="cta-best-blackjack-card-left">
									<div class="cta-best-blackjack-card-left-logo">
										<span><?php echo $count;?></span>
										<div class="cta-best-blackjack-card-left-logo-main">
                                            <?php if($site['blackjack_logo']){ ?>
											<img src="<?php echo $site['blackjack_logo'];?>">
                                            <?php } ?>
										</div>
									</div>
									<div class="cta-best-blackjack-card-left-items">
                                    <?php if($site['blackjack_title']){ ?>
										<h4><a ><?php echo $site['blackjack_title'];?></a></h4>
                                        <?php } ?>
                                        <?php if($site['blackjack_info']){ ?>
										<p><?php echo $site['blackjack_info']; ?></p>
                                        <?php } ?>
									</div>
								</div>
								<div class="cta-best-blackjack-card-right">
									<a href="<?php echo $site['blackjack_claim_url']; ?>" class="claim-btn">
										<img src="<?php echo get_template_directory_uri() . '/assets/'?>img/material-symbols_check-circle-rounded.svg"> Claim </a>
								</div>
							</div>
                        <?php  endforeach; ?>
			</div>
            <!-- end html -->
            <?php
                        }    endwhile; endif;
            return ob_get_clean();
        }
    }
}
if (class_exists('Blackjack_sites_Shortcode')) {
    $site_shortcode = new Blackjack_sites_Shortcode();
}
?>