<?php 
if ( ! defined( 'ABSPATH' ) ) {
exit; // Exit if accessed directly.
}

add_action( 'wp_enqueue_scripts', function() 
{
   wp_enqueue_style( 'cm-new-blog-single-font1-css', 'https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap',array(), mt_rand(0, 9999) , 'all' );
	 wp_enqueue_style( 'cm-new-blog-single-font2-css', 'https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap',array(), mt_rand(0, 9999) , 'all' );
	 wp_enqueue_style( 'cm-new-blog-single-font3-css', 'https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap',array(), mt_rand(0, 9999) , 'all' );
	 wp_enqueue_style( 'cm-new-blog-single-font4-for-widget-css', 'https://fonts.googleapis.com/css2?family=DM+Sans:opsz,wght@9..40,400;9..40,700&display=swap',array(), mt_rand(0, 9999) , 'all' );

    wp_enqueue_style( 'cm-new-blog-single-css', get_stylesheet_directory_uri().'/assets/css/blog-single-page-new.css',array(), mt_rand(0, 9999) , 'all' );
} );
gt_set_post_view(); 
get_header();
global $post;

?>

<section class="blog-single-page-wapper">
		<div class="container w-1440">
			<div class="row">
				<div class="col-12 col-lg-8">
					<div class="blog-single-card-wapper">
						<div class="blog-single-title">
							<h1><?php the_title(); ?></h1>
							<div class="casinomaxius-author-box">
								
									<!-- start code -->
									<?php 
										$author_id = get_the_author_meta('ID');
										
									?>
									<div class="casinomaxius-author-box-main ">
										<div class="cab-left">
											<div class="cab-left-items">
												<div class="cab-left-items-img">
													<a href=""><img src="<?php echo get_avatar_url($author_id)?>" alt=""></a>
												</div>
												<div class="cab-left-items-text">
													<div class="cab-left-items-text-top">
														<h4><a href="<?php echo get_author_posts_url($author_id) ?>"><?php echo  get_the_author_meta( 'display_name', $author_id ); ?></a></h4>
														<img src="<?php echo  get_bloginfo('template_url')."/assets/img/info.svg"?>" alt="Info">
														<?php if(get_the_author_meta('linkedin_profile',$author_id)){ ?>
														<a href="<?php echo get_the_author_meta('linkedin_profile',$author_id);?>"><i class="fab fa-linkedin"></i></a>
														<?php } ?>
													</div>
													<div class="cab-left-items-text-bottom">
														<div class="cab-left-items-text-bottom-left">
															<p><?php 
															$user = get_userdata( $author_id );

															$user_roles = $user->roles[0];
															echo ucfirst($user_roles);?>
															</p>
															<img src="<?php echo  get_bloginfo('template_url')."/assets/img/yes.svg"?>" alt="Yes">
														</div>
														<div class="cab-left-items-text-bottom-right">
															<?php 
																$fact_check_author_id=get_field('facts_checked_by',$post->ID);
																if($fact_check_author_id){
															?>
															<p>Fact Checked by  <a href="<?php echo get_author_posts_url($fact_check_author_id) ?>"><?php echo  get_the_author_meta( 'display_name', $fact_check_author_id); ?></a></p>
															<img src="<?php echo  get_bloginfo('template_url')."/assets/img/info.svg"?>" alt="Info">
															<?php } ?>
														</div>
													</div>
												</div>

											</div>
											<div class="cab-left-bottom">
												<h5>Last updated <span><?php echo get_the_modified_date()?> </span></h5>
											</div>
										</div>
										<div class="cab-right">
											<div class="cab-right-btn">
												<a href="<?php echo get_author_posts_url($author_id) ?>"><img src="<?php echo  get_bloginfo('template_url')."/assets/img/info.svg"?>" alt=""> Disclosure </a>
											</div>
											<div class="cab-right-icon ">
												<?php if(get_the_author_meta('facebook',$author_id)){ ?>
												<a href="<?php echo get_the_author_meta('facebook',$author_id);?>"><i class="fab fa-facebook-f"></i></a>
												<?php } ?>
												<?php if(get_the_author_meta('whatsapp_contact',$author_id)){ ?>
												<a href="tel:<?php echo get_the_author_meta('whatsapp_contact',$author_id); ?>"><i class="fab fa-whatsapp"></i></a>
												<?php } ?>
											</div>
										</div>

									</div>
									<!-- end code -->
						
							</div>
							<div class="blog-single-bottom">
								<!-- <ul class="blog-single-left">
									<li><a href="<?php the_permalink();?>"><img src="<?php echo  get_bloginfo('template_url')."/assets/img/clock.svg"?>" class="img-fluid"><?php echo get_the_date('d.m.Y');?></a></li>
						<li>|</li>
						<li><a href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>"><?php the_author();?></a></li>
								</ul>
								<ul class="blog-single-right">
									<li><a href="<?php the_permalink();?>"><img src="<?php echo  get_bloginfo('template_url')."/assets/img/majesticons_comments-line.svg"?>"><?php echo get_comments_number(get_the_ID());?></a></li>
						<li><a href="<?php the_permalink();?>"><img src="<?php echo  get_bloginfo('template_url')."/assets/img/icon-park-outline_preview-open.svg"?>"><?= gt_get_post_view(); ?></a></li>
								</ul> -->
							</div>
						</div>
						<div class="blog-single-page-card">
						<?php if ( has_post_thumbnail() ) { ?>
							<div class="blog-single-top-img">
								<?php the_post_thumbnail();?>
							</div>
							<?php } ?>
							<p><?php the_content(); ?></p>
						</div>
					</div>
					<hr class="bsp-hr">
					<!-- author box desing start -->
					<div class="author-box-wapper">
						<div class="author-box-top">
							<h3><?php the_author_meta('display_name', $author_id); ?></h3>
							<h4>author</h4>
						</div>
						<div class="author-box-bottom">
							<div class="author-box-img">
								<img src="<?php echo get_avatar_url($author_id);?>" alt="">
							</div>
							<div class="author-box-text">
								<p><?php the_author_meta( 'description' , $author_id );?></p>
								<hr class="bsp-hr">
								<a href="mailto:<?php echo get_the_author_meta('user_email');?>"><?php echo get_the_author_meta('user_email');?></a>
							</div>
						</div>
					</div>
					<!-- author box desing end -->
				</div>
				<div class="col-12 col-lg-4 bsp-mt--30">
					<!-- widget section start -->
					<div class="widget-section">
						<div class="">
							<div class="widget-wapper">
								<div class="get-title">
									<h1>Get insider tips and tricks in our newsletter</h1>
								</div>
								<?php  echo do_shortcode('[forminator_form id="626"]');?>
								<p>By typing thus button you agree to <u>terms and conditions</u></p>
								<div class="stay-up">
									<div class="stay-up-inner">
										<label class="container-check">Stay up to date with latest trends and advancements in AI chat technology with our exclusive news
											<input type="checkbox">
											<span class="checkmark"></span>
										</label>
									</div>
								</div>
							</div>
						</div>
					</div>
					
					<!-- widget section end -->
					<?php 
							$bnr1=get_field('ad_banner_1','option');
						
							if(!empty($bnr1)){
					?>
					<div class="ad-banner-wapper1">
						<?php 
						
								echo $bnr1;
							
						?>
					</div>
					<?php } ?>
					<?php
					$bnr2=get_field('ad_banner_2','option');
						
					if(!empty($bnr2)){
					?>
					<div class="ad-banner-wapper">
						<?php 
							
								echo $bnr2;
					
						?>
					</div>
					<?php } ?>
				</div>
			</div>
			<?php  //   $number= get_comments_number(get_the_ID()); 
		//	if( $number > 0){
			?>
<!-- 			<div class="view-comment-btn">
				<a href="#comments">View all comments</a>
			</div>
			<?php// } ?>
			<div class="comment-form-wapper">
				<?php // comments_template(); ?>
			</div> -->
		</div>
	</section>

<?php get_footer();?>