<?php
if ( ! defined( 'ABSPATH' ) ) {
exit; // Exit if accessed directly.
}
$version_ = mt_rand(0, 9999).'.'.mt_rand(0, 9999).'.'.mt_rand(0, 9999);
add_action( 'wp_enqueue_scripts', function() 
{
    $themeUrl = get_template_directory_uri();
 wp_enqueue_style( 'cm-cat-review-page-css', get_stylesheet_directory_uri().'/assets/css/best-of-page.css',array(), mt_rand(0, 9999) , 'all' );
	  wp_enqueue_script( 'cm-cat-review-js', get_stylesheet_directory_uri().'/assets/js/best-of-page.js',array(), mt_rand(0, 9999) , 'all' );
    } );
 get_header();?>

<?php
$category_name = single_cat_title( '', false );
$obj = get_queried_object();
$cat_slug = $obj->slug;

?>
	<section class="bof-c-wapper">
		<div class="container w-1440">
			<h2 class="bof-title"><?php  echo $category_name; ?></h2>
			<?php
				$args = array(
					        'post_type' => 'review-post',
									'posts_per_page' => -1,
									'orderby' => 'date',
								
									'tax_query' => array(
										array(
											'taxonomy' =>'offer_category', 
											'field' => 'slug',
											'terms' => $cat_slug
										)
									)
								);
					
						$category_query = new WP_Query( $args );
			
					 if($category_query ->have_posts()):
                        while($category_query ->have_posts()):

                                               $category_query ->the_post();
                    
                ?>
				<div class="bof-main-card">
					<div class="bof-top-card">
						<div class="bof-frame-a">
							<div class="bof-frame-img">
								<span class="bof-number"><?= gt_get_post_view(); ?></span>
								<div class="bof-img">
										<?php the_post_thumbnail();?>
								</div>
							</div>
							<div class="bof-frame-name">
								<h3><?php the_title() ;?></h3>
								<p><i class="fas fa-circle"></i><span><?php echo get_field('title_2'); ?></span></p>
							</div>
						</div>
						<div class="bof-frame-b">
							<div class="bof-slider-rating">
								<span class="bof-table-rating" rating="<?php echo get_field('rating'); ?>">
									<span class="star"></span>
									<span class="star"></span>
									<span class="star"></span>
									<span class="star"></span>
									<span class="star"></span>
								</span>
								<p class="rating-table"><span id="bof-rating-table"></span></p>
							</div>
							<a href="<?php echo get_field('new_player_link'); ?>">New players only</a>
						</div>
						<div class="bof-frame-c">
							<a href="<?php echo get_field('claim_link'); ?>" class="bof-claim-btn"><img src="<?php echo  get_bloginfo('template_url')."/assets/img/material-symbols_check-circle-rounded.svg"?>"> Claim</a>
							<a href="<?php echo get_field('read-review_link'); ?>" class="bof-read-review-btn"><img src="<?php echo  get_bloginfo('template_url')."/assets/img/material-symbols_arrow-circle-right-outline-rounded.svg"?>">Read Review</a>
						</div>
					</div>
					<div class="bof-text">
						<p>
						    <?php echo get_field('details'); ?>
						</p>
					</div>
				</div>
				<?php endwhile; wp_reset_postdata(); 
				else:
				echo '<p style="color:white;">Sorry No any Posts Found...</p>';
				endif; ?>
			
			</div>
	</section>
<?php get_footer(); ?>