<?php 
  /*
   * Template name: All Authors
   */
  add_action( 'wp_enqueue_scripts', function() 
  {
	  $themeUrl = get_template_directory_uri();
	  wp_enqueue_style( 'cm-all-authors-css', get_stylesheet_directory_uri().'/assets/css/author.css',array(), mt_rand(0, 9999) , 'all' );

 	  } );
   
get_header(); ?>
<div class="content-writer-section">
		<div class="container w-1440">
			<div class="content-writer-wapper">
				<?php 

	            $authors=get_users(array('role' => 'author' ));
                foreach($authors as $author){
                    $author_id =$author->ID;
                ?>
           
				<div class="content-writer-card-wapper">
					<div class="content-writer-card-img-icon-wapper">
						<div class="content-writer-card-img">
							<img src="<?php echo get_avatar_url($author_id)?>" alt="">
						</div>
						<ul>
                        <?php if(!empty(get_the_author_meta('facebook',$author_id))) { ?>
							<li><a href="<?php the_author_meta('facebook',$author_id); ?>" title="Facebook" target="_blank" id="facebook"><svg width="40" height="41" viewBox="0 0 40 41" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path fill-rule="evenodd" clip-rule="evenodd" d="M20 40.5C31.0457 40.5 40 31.5457 40 20.5C40 9.45431 31.0457 0.5 20 0.5C8.95431 0.5 0 9.45431 0 20.5C0 31.5457 8.95431 40.5 20 40.5Z" fill="white"/>
								<path d="M17.7404 30.5001L17.7142 22.3751H14.2856V18.893H17.7142V16.5716C17.7142 13.4386 19.6245 11.9287 22.3764 11.9287C23.6945 11.9287 24.8274 12.0284 25.1576 12.0729V15.3471L23.249 15.348C21.7524 15.348 21.4626 16.0703 21.4626 17.1301V18.893H25.7142L24.5714 22.3751H21.4626V30.5001H17.7404Z" fill="#35654D"/>
							  </svg></a></li>
							  <?php } ?>
							<?php if(!empty(get_the_author_meta('twitter',$author_id))) { ?>
							<li><a href="<?php the_author_meta('twitter',$author_id); ?>" title="Twitter" target="_blank" id="twitter"><svg width="40" height="41" viewBox="0 0 40 41" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path fill-rule="evenodd" clip-rule="evenodd" d="M20 40.5C31.0457 40.5 40 31.5457 40 20.5C40 9.45431 31.0457 0.5 20 0.5C8.95431 0.5 0 9.45431 0 20.5C0 31.5457 8.95431 40.5 20 40.5Z" fill="white"/>
								<path d="M28.5711 15.0058C27.9282 15.3354 27.2854 15.4453 26.5354 15.5552C27.2854 15.1157 27.8211 14.4563 28.0354 13.5772C27.3925 14.0168 26.6425 14.2365 25.7854 14.4563C25.1425 13.797 24.1782 13.3574 23.2139 13.3574C21.3925 13.3574 19.7854 15.0058 19.7854 16.9838C19.7854 17.3135 19.7854 17.5332 19.8925 17.753C16.9997 17.6431 14.3211 16.2146 12.6068 14.0168C12.2854 14.5662 12.1782 15.1157 12.1782 15.8849C12.1782 17.0937 12.8211 18.1926 13.7854 18.8519C13.2497 18.8519 12.7139 18.6321 12.1782 18.4124C12.1782 20.1706 13.3568 21.5992 14.9639 21.9289C14.6425 22.0387 14.3211 22.0387 13.9997 22.0387C13.7854 22.0387 13.5711 22.0387 13.3568 21.9289C13.7854 23.3574 15.0711 24.4563 16.6782 24.4563C15.4997 25.4453 13.9997 25.9948 12.2854 25.9948C11.9639 25.9948 11.7497 25.9948 11.4282 25.9948C13.0354 26.9838 14.8568 27.6431 16.7854 27.6431C23.2139 27.6431 26.7497 22.1486 26.7497 17.4234C26.7497 17.3135 26.7497 17.0937 26.7497 16.9838C27.4997 16.4343 28.1425 15.775 28.5711 15.0058Z" fill="#35654D"/>
							  </svg></a></li>
							  <?php } ?>
							  <?php if(!empty(get_the_author_meta('reddit_link',$author_id))) { ?>
							<li><a href="<?php the_author_meta('reddit_link',$author_id); ?>"><svg width="40" height="41" viewBox="0 0 40 41" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path fill-rule="evenodd" clip-rule="evenodd" d="M20 40.5C31.0457 40.5 40 31.5457 40 20.5C40 9.45431 31.0457 0.5 20 0.5C8.95431 0.5 0 9.45431 0 20.5C0 31.5457 8.95431 40.5 20 40.5Z" fill="white"/>
								<path d="M30 19.5469C29.9999 19.0602 29.8528 18.5838 29.5761 18.1743C29.2995 17.7649 28.9051 17.4396 28.4397 17.2374C27.9744 17.0351 27.4577 16.9642 26.9513 17.0333C26.4448 17.1024 25.9699 17.3084 25.583 17.6269C24.1855 16.9205 22.516 16.4935 20.7722 16.3943L21.2052 13.9202L22.6837 14.1361C22.7587 14.5798 22.9961 14.984 23.3541 15.2772C23.712 15.5704 24.1674 15.7338 24.6398 15.7385C25.1121 15.7432 25.571 15.5888 25.9353 15.3028C26.2996 15.0168 26.5459 14.6174 26.6306 14.1753C26.7154 13.7333 26.6331 13.2769 26.3983 12.887C26.1636 12.497 25.7915 12.1986 25.3478 12.0444C24.9041 11.8902 24.4174 11.8902 23.9737 12.0443C23.53 12.1985 23.1579 12.4969 22.9231 12.8868L20.7538 12.5693C20.5803 12.5439 20.4032 12.5845 20.2609 12.6824C20.1186 12.7803 20.0227 12.9276 19.9938 13.0924L19.4206 16.3847C17.5984 16.4594 15.8479 16.8911 14.3928 17.6269C13.8615 17.1999 13.1758 16.987 12.482 17.0336C11.7881 17.0801 11.1407 17.3825 10.6776 17.8763C10.2145 18.3701 9.97231 19.0164 10.0025 19.6775C10.0327 20.3386 10.333 20.9624 10.8394 21.4161C10.7096 21.8404 10.6436 22.28 10.6433 22.7218C10.6433 24.4624 11.6445 26.0832 13.4726 27.2849C15.2222 28.4366 17.5358 29.0716 19.9879 29.0716C22.44 29.0716 24.7537 28.4366 26.5033 27.2849C28.3313 26.0832 29.3325 24.4624 29.3325 22.7218C29.3322 22.28 29.2662 21.8404 29.1365 21.4161C29.4079 21.1779 29.6247 20.8889 29.7732 20.5672C29.9218 20.2456 29.999 19.8983 30 19.5469ZM24.6602 13.1972C24.7922 13.1972 24.9213 13.2344 25.0311 13.3042C25.1408 13.3739 25.2264 13.4731 25.2769 13.5891C25.3274 13.7052 25.3406 13.8328 25.3149 13.956C25.2891 14.0792 25.2255 14.1923 25.1322 14.2811C25.0389 14.3699 24.9199 14.4304 24.7904 14.4549C24.661 14.4794 24.5268 14.4668 24.4048 14.4188C24.2828 14.3707 24.1786 14.2893 24.1052 14.1849C24.0319 14.0805 23.9928 13.9577 23.9928 13.8321C23.9928 13.6637 24.0631 13.5022 24.1883 13.3831C24.3134 13.2641 24.4832 13.1972 24.6602 13.1972ZM15.3156 21.4519C15.3156 21.2007 15.3939 20.9551 15.5406 20.7463C15.6873 20.5375 15.8958 20.3747 16.1397 20.2786C16.3836 20.1824 16.652 20.1573 16.911 20.2063C17.17 20.2553 17.4078 20.3763 17.5945 20.5539C17.7812 20.7315 17.9083 20.9578 17.9599 21.2041C18.0114 21.4504 17.9849 21.7058 17.8839 21.9378C17.7829 22.1699 17.6117 22.3682 17.3922 22.5078C17.1727 22.6473 16.9146 22.7218 16.6506 22.7218C16.2965 22.7218 15.957 22.588 15.7066 22.3498C15.4563 22.1117 15.3156 21.7887 15.3156 21.4519ZM22.9707 25.8229C22.0522 26.2872 21.028 26.53 19.9879 26.53C18.9478 26.53 17.9236 26.2872 17.0052 25.8229C16.9277 25.7838 16.8591 25.7306 16.8032 25.6663C16.7474 25.6019 16.7054 25.5278 16.6797 25.448C16.654 25.3683 16.645 25.2845 16.6533 25.2015C16.6616 25.1184 16.6871 25.0378 16.7282 24.9641C16.7692 24.8904 16.8252 24.8251 16.8928 24.772C16.9604 24.7188 17.0383 24.6789 17.1222 24.6544C17.206 24.63 17.2941 24.6215 17.3814 24.6294C17.4687 24.6373 17.5534 24.6615 17.6309 24.7005C18.3566 25.0676 19.166 25.2595 19.9879 25.2595C20.8098 25.2595 21.6192 25.0676 22.3449 24.7005C22.4224 24.6615 22.5072 24.6373 22.5945 24.6294C22.6818 24.6215 22.7699 24.63 22.8537 24.6544C22.9375 24.6789 23.0154 24.7188 23.0831 24.772C23.1507 24.8251 23.2066 24.8904 23.2477 24.9641C23.2888 25.0378 23.3142 25.1184 23.3225 25.2015C23.3308 25.2845 23.3219 25.3683 23.2962 25.448C23.2704 25.5278 23.2285 25.6019 23.1726 25.6663C23.1168 25.7306 23.0482 25.7838 22.9707 25.8229ZM23.3253 22.7218C23.0613 22.7218 22.8032 22.6473 22.5836 22.5078C22.3641 22.3682 22.193 22.1699 22.092 21.9378C21.9909 21.7058 21.9645 21.4504 22.016 21.2041C22.0675 20.9578 22.1946 20.7315 22.3813 20.5539C22.568 20.3763 22.8059 20.2553 23.0648 20.2063C23.3238 20.1573 23.5922 20.1824 23.8361 20.2786C24.0801 20.3747 24.2886 20.5375 24.4352 20.7463C24.5819 20.9551 24.6602 21.2007 24.6602 21.4519C24.6602 21.7887 24.5196 22.1117 24.2692 22.3498C24.0189 22.588 23.6793 22.7218 23.3253 22.7218Z" fill="#35654D"/>
							  </svg></a></li>
							  <?php } ?>
						</ul>
					</div>
					<div class="content-writer-card-inner-wapper">
						<h4><?php echo  get_the_author_meta( 'display_name', $author_id ); ?></h4>
						<h6><?php echo $author->roles[0]; ?></h6>
                        <?php if(!empty(get_the_author_meta('description',$author_id))) { ?>
                        <p><?php echo get_the_author_meta('description',$author_id); ?> </p>
                        <?php } ?>
                    </div>
				</div>
                <?php } ?>
			</div>
		</div>
	</div>
<?php get_footer(); ?>