<?php 
  /*
   * Template name: All Categories
   */
  add_action( 'wp_enqueue_scripts', function() 
  {
	  $themeUrl = get_template_directory_uri();
	  wp_enqueue_style( 'cm-cat-css', get_stylesheet_directory_uri().'/assets/css/categories-page.css',array(), mt_rand(0, 9999) , 'all' );

 	  } );
   
get_header(); ?>
<section class="categories-a-wapper">
		<div class="container w-1440">
			<div class="categories-page-title">
				<h2>Gambling Guides</h2>			
				<div class="categories-right-top">
				    <div class="categories-search">
                        <form role="search" method="get" id="searchform" action="<?php echo get_permalink();?>">
                            <div class="categories-search-card" >
                                <span><img src="<?php echo  get_bloginfo('template_url')."/assets/img/blog_search.svg"?>" class="img-fluid" alt="search icon"></span>
                                <input type="search" name="search" class="form-control" value="<?php if ( isset( $_REQUEST[ 'search' ] ) ) { echo $_REQUEST[ 'search' ]; } ?>">
                            </div>
                            <div class="categories-filter-btn">
                                <button><span><i class="fas fa-filter"></i>Filter</span></button>
                            </div>
                        </form>
                    </div>
				
				
				</div>
			</div>
			<div class="row categories-row">
			      <?php  if(have_posts())
			      {
			          while(have_posts()): the_post(); 
                         $categories = get_categories();
                        if ( isset( $_REQUEST[ 'search' ] ) )
                        {
                             $s= $_REQUEST[ 'search' ];
                            // post categories in results
                            $terms = get_terms( array(
                                'name__like' => $s,
                                 'taxonomy'=> 'category',
                                'hide_empty' => false // Optional 
                                ) );
                            
                            if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
                            foreach( $terms as $category )
                            {
                            
                          
                                   
                                 $taxonomy = $category->taxonomy;
                               $term_id = $category->term_id; 
                                $image = get_field('category_image', $category->taxonomy . '_' . $category->term_id );
                                ?>
                                 <div class="col-12 col-md-6 col-xl-4 mb--32">
                					<div class="categories-main-wapper" style="background-image:url(<?php echo $image["url"]; ?>)">
                						<div class="categories-btn">
                							<a href="<?php echo get_category_link($category->term_id);?>"><?php echo $category->name;?></a>
                						</div>
                					</div>
                				</div>
                            <?php
                        	  }
                                }
                                 else{
			        echo "<p class='cat-not'>Sorry No Category Found.....</p>";
			    }
                     }
			      
                     else{
    					 foreach( $categories as $category ) {
                            $taxonomy = $category->taxonomy;
                            $term_id = $category->term_id; 
                            $image = get_field('category_image', $category->taxonomy . '_' . $category->term_id );
                          
                            ?>	
            				<div class="col-12 col-md-6 col-xl-4 mb--32">
            					<div class="categories-main-wapper" style="background-image:url(<?php echo $image["url"]; ?>)">
            						<div class="categories-btn">
            							<a href="<?php echo get_category_link($category->term_id);?>"><?php echo $category->name;?></a>
            						</div>
            					</div>
            				</div>
			    <?php }  } endwhile; }
			   
			    ?>
			</div>


		</div>
	</section>


<?php get_footer(); ?>