<?php 
  /*
   * Template name: Best Of Pages
   */
  add_action( 'wp_enqueue_scripts', function() 
  {
	  $themeUrl = get_template_directory_uri();
	  wp_enqueue_style( 'cm-b-o-page-css', get_stylesheet_directory_uri().'/assets/css/best-of-page.css',array(), mt_rand(0, 9999) , 'all' );
	   wp_enqueue_script( 'cm-b-o-page-js', get_stylesheet_directory_uri().'/assets/js/best-of-page.js',array(), mt_rand(0, 9999) , 'all' );

 	  } );
   
get_header();
$current_lan = pll_current_language(); 
 ?>
	<section class="bof-c-wapper">
		<div class="container w-1440">
			<h2 class="bof-title">Best Of  Page</h2>
			 <?php 	$count=0;   
			            $terms = get_terms( array(
                    		'taxonomy' => 'offer_category',
                    	
                    	) );
                    ?>
			<div class="bof-menu-ul">
                <ul>
				   	<?php
                    
                        foreach ( $terms as $term ) {
                            $count++;
                        if($count==1) {
                            ?>
                             <li class="active"><a href="#<?php echo $term->slug; ?>"><?php echo $term->name; ?></a></li>
                            <?php
                       
                        }else{?>
                            <li ><a href="#<?php echo $term->slug; ?>"><?php echo $term->name; ?></a></li>
                            <?php	
                        
                        }
                      }
                      
                ?>	
				</ul>
			</div>
			<?php  foreach ( $terms as $term ) { 
			$category_description = category_description($term->term_id);
               
			?>
			    
			    <div class="bof-wapper" id="<?php echo $term->slug; ?>">
				<div class="bof-sub-text">
					<h3><?php echo $term->name; ?></h3>
					<p>
					    <?php 
					        if($category_description)
                             echo $category_description;
			
					    ?>
					</p>
					</div>
				<?php
	                     $args = array(
                            'post_type' => 'review-post',
                            'post_status' => 'publish',
                            'posts_per_page' => -1,
                            'tax_query' => array(
                                'relation' => 'AND',
                                array(
                                    'taxonomy' => 'offer_category',
                                    'field'    => 'slug',
                                    'terms'    => $term->slug,
                                ),
                             
                              ),        
                                'orderby'           => 'title'
                        );

    
				$the_query = new WP_Query( $args );
                      
                    if($the_query->have_posts()):
                        while($the_query->have_posts()):
                            $the_query->the_post();
                    
                ?>
				<div class="bof-main-card">
					<div class="bof-top-card">
						<div class="bof-frame-a">
							<div class="bof-frame-img">
								<span class="bof-number"><?= gt_get_post_view(); ?></span>
								<div class="bof-img">
										<?php the_post_thumbnail();?>
								</div>
							</div>
							<div class="bof-frame-name">
								<h3><?php the_title() ;?></h3>
								<p><i class="fas fa-circle"></i><span><?php echo get_field('title_2'); ?></span></p>
							</div>
						</div>
						<div class="bof-frame-b">
							<div class="bof-slider-rating">
								<span class="bof-table-rating" rating="<?php echo get_field('rating'); ?>">
									<span class="star"></span>
									<span class="star"></span>
									<span class="star"></span>
									<span class="star"></span>
									<span class="star"></span>
								</span>
								<p class="rating-table"><span id="bof-rating-table"></span></p>
							</div>
							<a href="<?php echo get_field('new_player_link'); ?>" target="_blank">
								
								<?php
						        	// Check rows exists.
									if( have_rows('new_players_only_text', 'option') ):
									    // Loop through rows.
									    while( have_rows('new_players_only_text', 'option') ) : the_row();

									        // Load sub field value.
									        $lang_name = get_sub_field('language_name');

									        if($lang_name == $current_lan)
									        {
									        	
									        	if(get_sub_field('button_text') != "")
									        	{
									        		echo get_sub_field('button_text');
									        	}
									        	else
									        	{
									        		echo "New Players only";
									        	}
									        }
									    // End loop.
									    endwhile;
									endif;
								?>
							</a>
						</div>
						<div class="bof-frame-c">
							<a href="<?php echo get_field('claim_link'); ?>" class="bof-claim-btn" target="_blank"><img src="<?php echo  get_bloginfo('template_url')."/assets/img/material-symbols_check-circle-rounded.svg"?>"> 
								<?php
						        	// Check rows exists.
									if( have_rows('cta_button', 'option') ):
									    // Loop through rows.
									    while( have_rows('cta_button', 'option') ) : the_row();

									        // Load sub field value.
									        $lang_name = get_sub_field('language_name');

									        if($lang_name == $current_lan)
									        {
									        	
									        	if(get_sub_field('button_text') != "")
									        	{
									        		echo get_sub_field('button_text');
									        	}
									        	else
									        	{
									        		echo "Claim";
									        	}
									        }
									    // End loop.
									    endwhile;
									endif;
								?>
							</a>
							<a href="<?php echo get_the_permalink(); ?>" class="bof-read-review-btn" target="_blank"><img src="<?php echo  get_bloginfo('template_url')."/assets/img/material-symbols_arrow-circle-right-outline-rounded.svg"?>">Read Review</a>
						</div>
					</div>
					<div class="bof-text">
						<p>
						    <?php echo get_field('details'); ?>
						</p>
					</div>
				</div>
				<?php endwhile; wp_reset_postdata(); 
				else:
				echo '<p style="color:white;">Sorry No any Posts Found...</p>';
				endif; ?>
			
			</div>
            <?php } ?>
		
		</div>
	</section>


<?php get_footer(); ?>