<?php 
  /*
   * Template name: Blog Page
   */
  add_action( 'wp_enqueue_scripts', function() 
  {
	  $themeUrl = get_template_directory_uri();
	  wp_enqueue_style( 'cm-blog-css', get_stylesheet_directory_uri().'/assets/css/blog-page.css',array(), mt_rand(0, 9999) , 'all' );
	//    wp_enqueue_script( 'cm-blog-js', get_stylesheet_directory_uri().'/assets/js/main.js',array(), mt_rand(0, 9999) , 'all' );
	//     wp_localize_script('ajax' , 'wp_ajax',
    //     array('ajax_url' => admin_url('admin-ajax.php'))
    //     );
	  } );
   
get_header(); ?>
<section class="blog-a-wapper">
		<div class="container w-1440">
			<div class="blog-page-title">
				<h2>Our Blogs</h2>
				<div class="blog-right-top">
				    <div class="blog-search">
                        <form role="search" method="get" id="searchform" action="<?php echo get_permalink();?>">
                            <div class="search-card" >
                                <span><img src="<?php echo  get_bloginfo('template_url')."/assets/img/ion_search.svg"?>" class="img-fluid" alt="search icon"></span>
                                <input type="search" id="search" name="search" class="form-control" value="<?php if ( isset( $_REQUEST[ 'search' ] ) ) { echo $_REQUEST[ 'search' ]; } ?>">
                            </div>
                            <div class="filter-btn">
                                <button name="submit" type="submit"><span><i class="fas fa-filter"></i>Filter</span></button>
                            </div>
                        </form>
                    </div>
					
				</div>
			</div>
            <?php 	$paged = (get_query_var('paged'))  ? absint(get_query_var('paged')) : 1;
                   if ( isset( $_REQUEST[ 'search' ] ) ) {
                       global $post;
					   add_filter( 'posts_where', 'title_like_posts_where', 10, 2 );
					   function title_like_posts_where( $where, &$wp_query ) 
					   {
						   global $wpdb;
						   if ( $post_title_like = $wp_query->get( 'post_title_like' ) ) 
						   {
							   $where .= ' AND ' . $wpdb->posts . '.post_title LIKE \'%' . esc_sql( $wpdb->esc_like( $post_title_like ) ) . '%\'';
						   }
						   return $where;
					   }
                       $query = new WP_Query(array(
						'post_type'       => 'post', 
                        'post_title_like'           => $_REQUEST[ 'search' ] ,
                          'posts_per_page' => -1
					));
                   }else{
					$query = new WP_Query(array(
						'post_type' => 'post', 'post_status' => 'publish',
						'post_status' => 'publish', 'posts_per_page' => '6', 'paged' => $paged, 'orderby' => 'date', 'order' => 'DESC'
					));
                   }
					if ($query->have_posts()) {
					    
		    ?>
	
			<div class="row blog-row">
			    	<?php
				
					     while ($query->have_posts()) : 
					         $query->the_post(); 
					         $image = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'single-post-thumbnail' );
					          $cats = get_the_category($post->ID);
                                     foreach($cats as $cat){
                                         $cat_name=$cat->name;
                                         $cat_link= get_category_link($cat->term_id);
                                     }
					?>
				<div class="col-12 col-md-6 col-xl-4 mb--32">
					<div class="blog-main-wapper" style="background-image:url(<?php echo $image[0];?>)">
						<span class="blog-tag"><a href="<?php echo $cat_link; ?>"><?php echo $cat_name; ?></a></span>
						<div class="blog-text">
							<ul class="blog-top-ul">
								<li><a href="<?php the_permalink();?>"><img src="<?php echo  get_bloginfo('template_url')."/assets/img/clock.svg"?>" class="img-fluid"><?php echo get_the_date('d.m.Y');?></a></li>
								<li>|</li>
								<li><a href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>"><?php the_author(); ?></a></li>
							</ul>
							<h3>
								<a href="<?php the_permalink();?>"><?php the_title();?></a>
							</h3>
							<p><?php echo  preg_replace('`\[[^\]]*\]`', '',wp_trim_words(get_the_content(),  20,'...'));?>
    						</p>
    						<a href="<?php the_permalink();?>" class="read-more-btn">Read More <img src="<?php echo get_bloginfo('template_url')."/assets/img/ic_arrow-left.svg"?>" alt=""></a>
							<ul class="blog-bottom-ul">
								<li><a href="<?php the_permalink();?>"><img src="<?php echo  get_bloginfo('template_url')."/assets/img/majesticons_comments-line.svg"?>"><?php echo get_comments_number(get_the_ID());?></a></li>
								<li><a href="<?php the_permalink();?>"><img src="<?php echo  get_bloginfo('template_url')."/assets/img/icon-park-outline_preview-open.svg"?>"><?= gt_get_post_view(); ?></a></li>
							</ul>
						</div>
					</div>
				</div>
			<?php endwhile; ?>
			</div>

			<div class="blog-pagination">
				<center>
				    <?php
								$total_pages = $query->max_num_pages;
								if ($total_pages > 1) {
									$current_page = max(1, get_query_var('paged'));
									echo paginate_links(array(
										'base' => get_pagenum_link(1) . '%_%',
										'format' => '/page/%#%',
										'current' => $current_page,
										'total' => $query->max_num_pages,
										'prev_text' => '<',
										'next_text' => '>',
									));
								}
								?>
					
				</center>
			</div>
        <?php }else{ ?>
            <p style="color:#ffffff;font-size:22px;">Sorry, No Post Found....</p>
        <?php }?>
		</div>
	</section>

<?php get_footer(); ?>