<?php 
  /*
   * Template name: CTA Post Template
   *  Template Post Type:post
   */
  add_action( 'wp_enqueue_scripts', function() 
  {
    wp_enqueue_style( 'cm-cta-font1-css', 'https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;1,100;1,200;1,300;1,400;1,500;1,600;1,700&display=swap',array(), mt_rand(0, 9999) , 'all' );
    wp_enqueue_style( 'cm-cta-font2-css', '"https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;1,100;1,200;1,300;1,400;1,500;1,600;1,700&family=Oswald:wght@200;300;400;500;600;700&display=swap',array(), mt_rand(0, 9999) , 'all' );
    wp_enqueue_style( 'cm-cta-font3-css', 'https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap',array(), mt_rand(0, 9999) , 'all' );
    wp_enqueue_style( 'cm-cta-font4-for-widget-css', 'https://fonts.googleapis.com/css2?family=DM+Sans:opsz,wght@9..40,400;9..40,700&display=swap',array(), mt_rand(0, 9999) , 'all' );

	   wp_enqueue_style( 'cm-cta-page-css', get_stylesheet_directory_uri().'/assets/css/cta-page.css',array(), mt_rand(0, 9999) , 'all' );
	//    wp_enqueue_script( 'cm-b-o-page-js', get_stylesheet_directory_uri().'/assets/js/best-of-page.js',array(), mt_rand(0, 9999) , 'all' );

 } );
 global $wp_query; 
 $page_id = $wp_query->get_queried_object_id(); 
get_header();
$current_lan = pll_current_language();
 ?>
<div class="cta-page-wapper">
		<div class="container w-1440">
			<div class="row">
				<div class="col-lg-8">
					<div class="cta-page-main">
						<div class="cta-page-title">
							<h1><?php the_title(); ?></h1>
                            <div class="casinomaxius-author-box">
								
									<!-- start code -->
									<?php 
										$author_id = get_the_author_meta('ID');
										
									?>
									<div class="casinomaxius-author-box-main ">
										<div class="cab-left">
											<div class="cab-left-items">
												<div class="cab-left-items-img">
													<a href=""><img src="<?php echo get_avatar_url($author_id)?>" alt=""></a>
												</div>
												<div class="cab-left-items-text">
													<div class="cab-left-items-text-top">
														<h4><a href="<?php echo get_author_posts_url($author_id) ?>"><?php echo  get_the_author_meta( 'display_name', $author_id ); ?></a></h4>
														<img src="<?php echo  get_bloginfo('template_url')."/assets/img/info.svg"?>" alt="Info">
														<?php if(get_the_author_meta('linkedin_profile',$author_id)){ ?>
														<a href="<?php echo get_the_author_meta('linkedin_profile',$author_id);?>"><i class="fab fa-linkedin"></i></a>
														<?php } ?>
													</div>
													<div class="cab-left-items-text-bottom">
														<div class="cab-left-items-text-bottom-left">
															<p><?php 
															$user = get_userdata( $author_id );

															$user_roles = $user->roles[0];
															echo $user_roles?>
															</p>
															<img src="<?php echo  get_bloginfo('template_url')."/assets/img/yes.svg"?>" alt="Yes">
														</div>
														<div class="cab-left-items-text-bottom-right">
															<?php 
																$fact_check_author_id=get_field('facts_checked_by',$post->ID);
																if($fact_check_author_id){
															?>
															<p>Fact Checked by  <a href="<?php echo get_author_posts_url($fact_check_author_id) ?>"><?php echo  get_the_author_meta( 'display_name', $fact_check_author_id); ?></a></p>
															<img src="<?php echo  get_bloginfo('template_url')."/assets/img/info.svg"?>" alt="Info">
															<?php } ?>
														</div>
													</div>
												</div>

											</div>
											<div class="cab-left-bottom">
												<h5>Last updated <span><?php echo get_the_modified_date()?> </span></h5>
											</div>
										</div>
										<div class="cab-right">
											<div class="cab-right-btn">
												<a href="<?php echo get_author_posts_url($author_id) ?>"><img src="<?php echo  get_bloginfo('template_url')."/assets/img/info.svg"?>" alt=""> Disclosure </a>
											</div>
											<div class="cab-right-icon ">
												<?php if(get_the_author_meta('facebook',$author_id)){ ?>
												<a href="<?php echo get_the_author_meta('facebook',$author_id);?>"><i class="fab fa-facebook-f"></i></a>
												<?php } ?>
												<?php if(get_the_author_meta('whatsapp_contact',$author_id)){ ?>
												<a href="tel:<?php echo get_the_author_meta('whatsapp_contact',$author_id); ?>"><i class="fab fa-whatsapp"></i></a>
												<?php } ?>
											</div>
										</div>

									</div>
									<!-- end code -->
						
							</div>
							
						</div>
						<div class="cta-page-top-img">
							<?php  the_post_thumbnail(); ?>
						</div>
						<div class="cta-page-top-bottom-text">
							<?php the_content();?>
						</div>
						<!-- Best Blackjack site Start -->
						<div class="cta-best-blackjack-site-wapper">
							<div class="cta-best-blackjack-site-titel">
                                <?php if(get_field('blackjack_section_heading',$page_id)){ ?>
                                    <h2><?=get_field('blackjack_section_heading',$page_id); ?></h2>
                                    <?php }else{ ?>
								<h2>Best blackjack sites</h2>
                                <?php } ?>
							</div>
						
						<?php 
                            $count=0;
                            if(have_rows('best_blackjack_sites',$page_id)){
                                while(have_rows('best_blackjack_sites',$page_id)){
                                    the_row();
                                    $count++;
                        ?>
							<div class="cta-best-blackjack-card-main">
								<div class="cta-best-blackjack-card-left">
									<div class="cta-best-blackjack-card-left-logo">
										<span><?php echo $count;?></span>
										<div class="cta-best-blackjack-card-left-logo-main">
                                            <?php if(get_sub_field('blackjack_logo',$page_id)){ ?>
											<img src="<?php echo get_sub_field('blackjack_logo',$page_id);?>">
                                            <?php } ?>
										</div>
									</div>
									<div class="cta-best-blackjack-card-left-items">
                                    <?php if(get_sub_field('blackjack_title',$page_id)){ ?>
										<h4><a ><?php echo get_sub_field('blackjack_title',$page_id);?></a></h4>
                                        <?php } ?>
                                        <?php if(get_sub_field('blackjack_info',$page_id)){ ?>
										<p><?php echo get_sub_field('blackjack_info',$page_id) ?></p>
                                        <?php } ?>
									</div>
								</div>
								<div class="cta-best-blackjack-card-right">
									<a href="<?php echo get_sub_field('blackjack_claim_url',$page_id) ?>" class="claim-btn">
										<img src="<?php echo get_template_directory_uri() . '/assets/'?>img/material-symbols_check-circle-rounded.svg"> 
										<?php
						        		// Check rows exists.
										if( have_rows('cta_button', 'option') ):
										    // Loop through rows.
										    while( have_rows('cta_button', 'option') ) : the_row();

										        // Load sub field value.
										        $lang_name = get_sub_field('language_name');

										        if($lang_name == $current_lan)
										        {
										        	
										        	if(get_sub_field('button_text') != "")
										        	{
										        		echo get_sub_field('button_text');
										        	}
										        	else
										        	{
										        		echo "Claim";
										        	}
										        }
										    // End loop.
										    endwhile;
										endif;
										?>
									</a>
								</div>
							</div>
                        <?php }} ?>
						</div>
						<!-- Best Blackjack site End -->
						<!-- Our Score Start -->
                        <?php 
                            if(have_rows('blackjack_review_',$page_id)){ 
                                while(have_rows('blackjack_review_',$page_id)){ 
                                    the_row();
                        ?>
						<div class="our-score-wapper">
							<div class="our-score-top">
								<div class="our-score-top-left">
                                    <?php if(get_sub_field('rating',$page_id)){ ?>
									<h4><a ><?php echo get_sub_field('rating',$page_id);?></a></h4>
                                    <?php } ?>
									<p>Our Score</p>
								</div>
								<div class="our-score-top-right">
                                    <?php if(get_sub_field('review_title',$page_id)){ ?>
									<h3><?php echo get_sub_field('review_title',$page_id);?></h3>
                                    <?php } ?>
                                    <?php if(get_sub_field('review_detail',$page_id)){ ?>
									<p><?php echo get_sub_field('review_detail',$page_id); ?>
									</p>
                                    <?php } ?>
								</div>
							</div>
							<div class="our-score-pros-cons-wapper">
								<div class="our-score-pros">
                                <?php if(get_sub_field('pros',$page_id)){ 
                                    $pros=get_sub_field('pros',$page_id);
                                    ?>
									<h3>Pros</h3>
									<ul>
                                        <?php foreach($pros as $bpros){ ?>
										<li><img src="<?php echo get_template_directory_uri() . '/assets/'?>img/Check cr-fr.svg" alt=""><?php echo $bpros['blackjack_pros']?></li>
										<?php } ?>
									</ul>
                                    <?php }?>
								</div>
								<div class="our-score-cons">
									<h3>Cons</h3>
                                    <?php if(get_sub_field('cons',$page_id)){ 
                                    $cons=get_sub_field('cons',$page_id);
                                    ?>
									<ul>
                                    <?php foreach(  $cons as $bcons){ ?>
										<li><img src="<?php echo get_template_directory_uri() . '/assets/'?>img/Remove cr-fr.svg" alt=""><?php echo $bcons['blackjack_cons']?></li>
									<?php } ?>
									</ul>
                                    <?php } ?>
								</div>

							</div>
							<div class="our-score-btn">
                            <?php if(get_sub_field('claim_url',$page_id)){  ?>
								<a href="<?php echo get_sub_field('claim_url',$page_id); ?>">
									<img src="<?php echo get_template_directory_uri() . '/assets/'?>img/material-symbols_check-circle-rounded.svg"> 
									<?php
						        	// Check rows exists.
									if( have_rows('cta_button', 'option') ):
									    // Loop through rows.
									    while( have_rows('cta_button', 'option') ) : the_row();

									        // Load sub field value.
									        $lang_name = get_sub_field('language_name');

									        if($lang_name == $current_lan)
									        {
									        	
									        	if(get_sub_field('button_text') != "")
									        	{
									        		echo get_sub_field('button_text');
									        	}
									        	else
									        	{
									        		echo "Claim";
									        	}
									        }
									    // End loop.
									    endwhile;
									endif;
									?>
									 </a>
							<?php } ?>
                            </div>
						</div>
                        <?php }} ?>
						<!-- Our Score End -->
					</div>
				</div>
				<div class="col-12 col-lg-4 bsp-mt--30">
					<!-- widget section start -->
					<div class="widget-section">
						<div class="">
							<div class="widget-wapper">
								<div class="get-title">
									<h1>Get insider tips and tricks in our newsletter</h1>
								</div>
								<?php  echo do_shortcode('[forminator_form id="626"]');?>
								<p>By typing thus button you agree to <u>terms and conditions</u></p>
								<div class="stay-up">
									<div class="stay-up-inner">
										<label class="container-check">Stay up to date with latest trends and advancements in AI chat technology with our exclusive news
											<input type="checkbox">
											<span class="checkmark"></span>
										</label>
									</div>
								</div>
							</div>
						</div>
					</div>
					
					<!-- widget section end -->
					<?php 
							$bnr1=get_field('ad_banner_1','option');
						
							if(!empty($bnr1)){
					?>
					<div class="ad-banner-wapper1">
						<?php 
						
								echo $bnr1;
							
						?>
					</div>
					<?php } ?>
					<?php
					$bnr2=get_field('ad_banner_2','option');
						
					if(!empty($bnr2)){
					?>
					<div class="ad-banner-wapper">
						<?php 
							
								echo $bnr2;
					
						?>
					</div>
					<?php } ?>
				</div>
			</div>
		</div>
	</div>
	
<?php get_footer(); ?>