<?php 
  /*
   * Template name: General Page
   */
  add_action( 'wp_enqueue_scripts', function() 
  {
	  $themeUrl = get_template_directory_uri();
	  wp_enqueue_style( 'cm-general-page-css', get_stylesheet_directory_uri().'/assets/css/general-type-page.css',array(), mt_rand(0, 9999) , 'all' );
	   wp_enqueue_script( 'cm-general-js', get_stylesheet_directory_uri().'/assets/js/general-type-page.js',array(), mt_rand(0, 9999) , 'all' );

 	  } );
   
get_header(); 
$current_lan = pll_current_language();
?>
<section class="gpt-banner-wapper" style="background-image:url(<?php echo  get_bloginfo('template_url').'/assets/img/Frame--1.png'?>)">
		<div class="container w-1440">
			<div class="gpt-banner-text">
			    
				<h1><?php echo get_field('banner_title')?></h1>
				<hr>
				<p><?php echo get_field('description')?></p>
			</div>
		</div>
	</section>

	<section class="gpt-k-wapper">
		<div class="container w-1440">
			<h2 class="gpt-title">Top Rated Bookmakers</h2>
			<div class="gpt-k-row">
			     <?php
			 if(have_rows('top_bookmarkers')):
			    while(have_rows('top_bookmarkers')):
			        the_row();
			        $image = get_sub_field('image');
			        $image_url = $image['sizes']['thumbnail'];
			  ?>
				<div class="gpt-k-col">
					<div class="gpt-k-top">
						<div class="gpt-k-thumb">
							<a href="<?php if(get_sub_field('claim_link')){ echo get_sub_field('claim_link') ;}?>" target="_blank">
								<img src="<?php echo $image_url?>" alt="bookmark_img">
							</a>
						</div>
						<div class="gpt-k-text">
							<h3><a href="#"><?php echo  get_sub_field('title')?></a></h3>
							<span class="gpt-k-table-rating" rating="<?php echo get_sub_field('rating') ?>">
								<span class="star filled"></span>
								<span class="star"></span>
								<span class="star"></span>
								<span class="star"></span>
								<span class="star"></span>
							</span>
							<p><?php echo  get_sub_field('details');?></p>
						</div>
					</div>
					<a href="<?php echo  get_sub_field('claim_link')?>" class="gpt-k-claim" target="_blank"><img src="<?php echo  get_bloginfo('template_url').'/assets/img/material-symbols_check-circle-rounded.svg'?>">
							<?php
						        	// Check rows exists.
							if( have_rows('cta_button', 'option') ):
							    // Loop through rows.
							    while( have_rows('cta_button', 'option') ) : the_row();

							        // Load sub field value.
							        $lang_name = get_sub_field('language_name');

							        if($lang_name == $current_lan)
							        {
							        	
							        	if(get_sub_field('button_text') != "")
							        	{
							        		echo get_sub_field('button_text');
							        	}
							        	else
							        	{
							        		echo "Claim";
							        	}
							        }
							    // End loop.
							    endwhile;
							endif;
							?>
					</a>
				</div>
				<?php endwhile;  endif; ?>
			
			</div>
		</div>
	</section>

	<section class="gpt-h-wapper">
		<div class="container w-1440">
			<h2 class="gpt-title">New Bonuses</h2>
			<div class="row gpt-h-row">
	        <?php 
	           
                  if(have_rows('bonus_code')):
			    while(have_rows('bonus_code')):
			        the_row();    
                                   
			    ?>
				<div class="col-12 col-md-6 col-lg-4 col-xl-3 mb--32">
					<div class="gpt-bonuses-wapper">
						<div class="gpt-top-main">
							<div class="gpt-top-bonuses">
								<span><?php echo get_sub_field('type')?></span>
								<h3><?php echo get_sub_field('title')?></h3>
							</div>
							<div class="gpt-code-box">
								<span>Bonus Code</span>
								<h3><?php echo get_sub_field('code')?></h3>
							</div>
							<p>	<?php echo get_sub_field('detail')?></p>
						</div>
						<div class="gpt-bottom-btn">
							<a href="<?php echo get_sub_field('get_url')?>" class="gpt-get-bonus-btn" target="_blank">Get Bonus</a>
							<a href="<?php echo get_sub_field('t&c_link')?>" class="gpt-t-c-apply-link" target="_blank">T&CsApply</a>
						</div>
					</div>
				</div>
			<?php endwhile; endif;?>
			</div>
		</div>
	</section>

	<section class="gpt-questions-wapper">
		<div class="container w-1440">
			<h2 class="gpt-title">Questions and Answers</h2>
			<?php
			 if(have_rows('que&ans')):
			     while(have_rows('que&ans')):
			        the_row();
			?>
			<div class="gpt-qaa-wapper">
				<div class="gpt-qaa-title">
					<h3><?php echo get_sub_field('question');?></h3>
				</div>
				<div class="gpt-qaa-text">
					<p><?php echo get_sub_field('answer'); ?></p>
				</div>
			</div>
			<?php endwhile;  endif; ?>
		
		</div>
	</section>

<?php get_footer(); ?>