<?php 
  /*
   * Template name: Machine Page
   */
  add_action( 'wp_enqueue_scripts', function() 
  {
	  $themeUrl = get_template_directory_uri();
	  wp_enqueue_style( 'machine-page-css', get_stylesheet_directory_uri().'/assets/css/machine-page.css',array(), mt_rand(0, 9999) , 'all' );
	

 	  } );
   
get_header(); ?>
<section class="machine-wapper">
		<div class="container w-1440">
			<h1 class="machine-title"><?php  the_title();?></h1>
			<div class="row machine-row">
				<?php
					if(have_rows('machine_data')):
			    		while(have_rows('machine_data')):
			        		the_row();
					$image = get_sub_field('image');
			        $image_url = $image['sizes']['thumbnail'];
				?>
				<div class="col-12 col-md-6 col-lg-4">
					<div class="machine-card-wapper">
						<div class="machine-card-img">
							<img src="<?php echo $image_url?>" alt="Machine Image">
						</div>
						<div class="machine-card-text">
							<h2>
								<a href="<?php echo get_sub_field('title_url');?>" target="_blank"><?php echo get_sub_field('title');?>  <img src="<?php echo  get_bloginfo('template_url').'/assets/img/machine-arrow.svg'?>" alt=""></a>
							</h2>
						</div>
						<div class="machine-card-btn">
							<a href="<?php echo get_sub_field('play_for_free_url');?>" target="_blank">Play for free <img src="<?php echo  get_bloginfo('template_url').'/assets/img/machine-play-btn.svg'?>" alt="Pay"></a>
						</div>
					</div>
				</div>
				
		<?php endwhile; endif; ?>
			</div>
		</div>
	</section>
<?php get_footer(); ?>