<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class ITPL_Tournaments_Archive_Shortcode {

    public function __construct() {
        add_shortcode( 'tournaments_archive', array( $this, 'render_shortcode' ) );
        add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_assets' ) );
        add_action( 'wp_ajax_filter_tournaments', array( $this, 'handle_ajax' ) );
        add_action( 'wp_ajax_nopriv_filter_tournaments', array( $this, 'handle_ajax' ) );
    }

    public function enqueue_assets() {
        if ( is_post_type_archive('tournament') || has_shortcode( get_post()->post_content, 'tournaments_archive' ) ) {
            wp_enqueue_style( 'itpl-font-family','https://fonts.googleapis.com/css2?family=Mont:ital,wght@0,100..900;1,100..900&display=swap');
            wp_enqueue_style( 'itpl-font-awesome','https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css');
            wp_enqueue_style( 'itpl-bootstrapcss','https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css');
            wp_enqueue_style( 'itpl-tournaments-archive-style', plugin_dir_url( __DIR__ ) . 'assets/css/tournaments_archive.css', array(), rand(1000,9999) );

            wp_enqueue_script( 'jquery' );
            wp_enqueue_script('itpl-bootstrapjs','https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.min.js',array( 'jquery' ),'4.6.2',true);
            wp_enqueue_script( 'itpl-tournaments-archive-script', plugin_dir_url( __DIR__ ) . 'assets/js/tournaments_archive.js', array('jquery'), rand(1000,9999), true );
            wp_localize_script( 'itpl-tournaments-archive-script', 'itpl_ajax', array(
                'ajax_url' => admin_url( 'admin-ajax.php' ),
                'nonce'    => wp_create_nonce( 'tournaments_filter_nonce' ),
            ));
        }
    }

    private function restrict_search_to_title() {
        add_filter( 'posts_search', function( $search, $query ) {
            global $wpdb;

            if ( empty( $search ) || ! isset( $query->query_vars['s'] ) ) {
                return $search;
            }

        // Apply only to 'tournament' post type
            if ( isset( $query->query_vars['post_type'] ) && $query->query_vars['post_type'] !== 'tournament' ) {
                return $search;
            }

            $search_term = esc_sql( $query->query_vars['s'] );

            return " AND ({$wpdb->posts}.post_title LIKE '%{$search_term}%')";
        }, 10, 2 );
    }


    public function render_shortcode() {
        ob_start();
        ?>
        <div class="tournament-list-section">
            <div class="container w-1320">
                <div class="tournament-list-top-search-wapper">
                  
                    <form id="tournament-filter-form">
                        <div class="form-group">
                            <input type="text" name="s" class="form-control" placeholder="Search Tournaments">
                            <img src="<?php echo esc_url( plugin_dir_url( __DIR__ ) . 'assets/img/search.jpeg' ); ?>" alt="search" class="search-icon">
                        </div>
                        <div class="form-group date-picker">
                            <input type="date" name="date" class="form-control" placeholder="DD/MM/YYYY">
                        </div>
                        <input type="hidden" name="action" value="filter_tournaments">
                        <input type="hidden" name="nonce" value="<?php echo wp_create_nonce('tournaments_filter_nonce'); ?>">
                    </form>

                </div>

                <div class="tournament-list-wapper" id="tournament-results">
                    <?php $this->render_tournaments(); ?>
                </div>
            </div>
        </div>
        <?php
        return ob_get_clean();
    }

    private function render_tournaments( $search = '', $date = '', $paged = 1 )
    {
     $args = array(
        'post_type'      => 'tournament',
        'posts_per_page' => 6,
        'paged'          => $paged,
        's'              => $search,
    );
     if ( $date ) {
        $args['date_query'] = array(
            array(
                'year'  => date('Y', strtotime($date)),
                'month' => date('m', strtotime($date)),
                'day'   => date('d', strtotime($date)),
            )
        );
    }

    $this->restrict_search_to_title();
    $query = new WP_Query( $args );
    remove_all_filters( 'posts_search' );

    if ( $query->have_posts() ) : 
        echo '<div class="row">';
        while ( $query->have_posts() ) : $query->the_post();
            ?>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12">
                <div class="tournament-card-wapper">
                    <div class="tournament-card-img">
                        <?php if ( has_post_thumbnail() ) the_post_thumbnail( 'medium' ); ?>
                        <div class="tournament-tag-wapper">
                            <?php
                            $terms = get_the_terms(get_the_ID(), 'location');
                            if (!empty($terms)) {
                                foreach ($terms as $term) {
                                    echo '<a href="' . esc_url(get_term_link($term)) . '">' . esc_html($term->name) . '</a>';
                                }
                            }
                            ?>
                        </div>
                    </div>
                    <div class="tournament-card-inner">
                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                        <?php
                        $categories = get_the_category();
                        if (!empty($categories)) {
                            echo '<p>' . esc_html($categories[0]->name) . '</p>';
                        }
                        ?>
                        <div class="contact-btn">
                            <a href="<?php the_permalink(); ?>">Contact Office</a>
                        </div>
                    </div>
                </div>
            </div>
            <?php
        endwhile;
        
        echo '</div>';
              // Pagination links
        $total_pages = $query->max_num_pages;
        if ( $total_pages > 1 ) {
            echo '<div class="pagination-wapper"><ul>';
            for ( $i = 1; $i <= $total_pages; $i++ ) {
                echo '<li><a href="#" class="pagination-link" data-page="' . $i . '">' . $i . '</a></li>';
            }
            echo '</ul></div>';
        }

        wp_reset_postdata();
    else :
        echo '<p>No tournaments found.</p>';
    endif;
}

public function handle_ajax() {
    check_ajax_referer( 'tournaments_filter_nonce', 'nonce' );

    $search = sanitize_text_field( $_POST['s'] ?? '' );
    $date   = sanitize_text_field( $_POST['date'] ?? '' );
    $paged  = intval( $_POST['paged'] ?? 1 );
    ob_start();
    $this->render_tournaments( $search, $date, $paged );
    wp_send_json_success( ob_get_clean() );
}
}
