<?php
class ITPL_Tournament_Single_Post_Shortcode {

    public function __construct() {
        add_shortcode( 'tournament_single_post', array( $this, 'render_shortcode' ) );
        add_action( 'wp_enqueue_scripts', array( $this, 'tournament_enqueue_assets' ) );
    }
    public function tournament_enqueue_assets() {
        if ( is_singular( 'tournament' ) ) {
            wp_enqueue_style( 'itpl-font-family','https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap',array(),rand(100, 999));
            wp_enqueue_style( 'itpl-font-awesome','https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css',array(),rand(100, 999));
            wp_enqueue_style( 'itpl-bootstrapcss','https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css',array(),rand(100, 999));
            wp_enqueue_style( 'itpl-OwlCarousel2','https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css',array(),rand(100, 999));
            wp_enqueue_style( 'itpl-fancybox','https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.css',array(),rand(100, 999));
            wp_enqueue_style( 'itpl-tournament-single-postcss', plugin_dir_url( __DIR__ ) . 'assets/css/tournament_single_post.css', array(), rand(100, 999));

            wp_enqueue_script( 'jquery' );
            wp_enqueue_script('itpl-bootstrapjs','https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.min.js',array( 'jquery' ),'4.6.2',true);
            wp_enqueue_script('itpl-owl-carousel','https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js',array( 'jquery' ),'2.3.4',true);
            wp_enqueue_script('itpl-fancybox','https://cdn.jsdelivr.net/npm/@fancyapps/fancybox@3.5.6/dist/jquery.fancybox.min.js',array( 'jquery' ),'3.5.6',true);
            wp_enqueue_script('itpl-tournament-single-postjs',plugin_dir_url( __DIR__ ) . 'assets/js/tournament_single_post.js',array( 'jquery' ),rand(100, 999),true);
        }
    }

    public function render_shortcode() {
        global $post;

        if ( ! $post || $post->post_type !== 'tournament' ) {
            return '<p>Tournament not found.</p>';
        }

        ob_start();

        $bannerimages = get_field('select_banner_images', $post->ID);
        ?>
        <div class="tournament-details-banner-section">
            <div class="owl-carousel" id="tournament-details-banner">
                <?php if ( $bannerimages ) : ?>
                    <?php foreach ( $bannerimages as $bannerimage ) : ?>
                        <div class="item">
                            <div class="tournament-details-banner-card">
                                <img src="<?php echo esc_url( $bannerimage ); ?>">
                            </div>
                        </div>
                    <?php endforeach; ?> 
                <?php endif; ?>
            </div>
        </div>
        <!-- tournament details content section start  -->


        <div class="tournament-details-content-section">
            <div class="container w-1150">
                <div class="row">
                    <div class="col-xl-9 col-lg-9 col-md-12 col-12">
                        <div class="tournament-details-content-text-wapper">
                            <h2><?php the_title(); ?></h2>


                            <?php the_content(); ?>

                        </div>
                        <?php $galleryimages = get_field('select_gallery_images', $post->ID); ?>
                        <?php if ( $galleryimages ) : ?>

                            <div class="gallery-wapper">
                                <div class="tournament-details-gallery-title">
                                    <h2>Gallery</h2>
                                </div>
                                <div class="row">
                                   <?php foreach ( $galleryimages as $galleryimage ) : ?>
                                    <div class="col-xl-4 col-lg-4 col-md-6 col-12">
                                        <div class="tournament-gallery-card">
                                            <a data-fancybox="gallery" href="<?php echo esc_url( $galleryimage ); ?>">
                                                <img src="<?php echo esc_url( $galleryimage ); ?>" alt="Thumbnail">
                                            </a>
                                        </div>
                                    </div>
                                <?php endforeach; ?>  
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="col-xl-3 col-lg-3 col-md-12 col-12">
                     <?php $sponsoredimages = get_field('select_sponsored_image', $post->ID); ?>
                        <?php if ( $sponsoredimages ) : ?>
                         
                    <div class="sponsored-by-title-wapper">
                        <h3>Sponsored By</h3>
                    </div>
                    <div class="sponsored-by-icon-wapper">
                           <?php foreach ( $sponsoredimages as $sponsoredimage ) : ?>
                        <div class="sponsored-by-img">
                            <img src="<?php echo esc_url( $sponsoredimage ); ?>" alt="sponsor">
                        </div>
                          <?php endforeach; ?>  
                    </div>
                     <?php endif; ?>
                </div>
            </div>
        </div>
    </div>


    <!-- tournament details content section start  -->
    <?php
    return ob_get_clean();
}
}
