<?php
/**
 * Plugin Name: ITPL Custom Code
 * Description: Adds custom shortcodes and functionality using OOP.
 * Version: 1.0
 * Author: icontechsoft
 * Author uri: https://icontechsoft.com
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


// Init class
class ITPL_Custom_Code {

    public function __construct() {
        add_action( 'init', array( $this, 'init_shortcodes' ) );
    }

    public function init_shortcodes() {
        require_once plugin_dir_path( __FILE__ ) . 'includes/class-shortcode-tournament-single-post.php';
        new ITPL_Tournament_Single_Post_Shortcode(); // [tournament_single_post]
        
        require_once plugin_dir_path( __FILE__ ) . 'includes/class-itpl-tournaments-archive-shortcode.php';
        new ITPL_Tournaments_Archive_Shortcode();
        
        require_once plugin_dir_path( __FILE__ ) . 'includes/class-shortcode-animated-text-section.php';
        new ITPL_Animated_Text_Shortcode();
    
    }
}

// Start the plugin
new ITPL_Custom_Code();
