<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Load WordPress environment
require_once($_SERVER['DOCUMENT_ROOT'] . '/simplewebsite_cosmicinfluence/wp-load.php');
require_once(get_stylesheet_directory() . '/TCPDF-main/tcpdf.php');
// if(isset($_GET['post_id'])){
     $id=$_GET['post_id'];
      $post = get_post($id);
        // echo "<br>";
  $post_title = esc_html($post->post_title);
//   echo "<br>";
  $terms = wp_get_post_terms($id, 'property_type'); 
   $term = $terms[0];
    $price = floatval(get_term_meta($term->term_id, '_property_price', true));
                $discount = floatval(get_term_meta($term->term_id, '_property_discount', true));
                $tax = floatval(get_term_meta($term->term_id, '_property_tax', true));
                $final_price = floatval(get_term_meta($term->term_id, '_property_final_price', true));
                if ($price > 0) {
                    $discounted_price = $price - ($price * ($discount / 100));
                    $discount_amount = $price - $discounted_price;
                    $tax_amount = round($discounted_price * ($tax / 100));
                    $price_with_tax = $discounted_price + $tax_amount;
                } else {
                    $discounted_price = 0;
                    $discount_amount = 0;
                    $tax_amount = 0;
                    $price_with_tax = 0;
                } 
                $total_price_sum=$price;
        if ($tax > 0) { 
                    $total_price_sum.=' (税込 ' . esc_html(number_format($tax_amount)) . ' 円)';
                }
                if ($discount > 0) {  
                   $total_price_sum.=' (' . esc_html(number_format($discount_amount)) . ' 円割引除く)'; 
                } 
                // echo  $total_price_sum;
    //  echo "<br>";
                $category_name = esc_html($term->name);
    // echo "<br>";
     $building_number = isset($_GET['buildingnumber']) ? intval($_GET['buildingnumber']) : 1;
    // echo "<br>";
    $remarks = isset($_GET['remarks']) ? sanitize_text_field($_GET['remarks']) : '';
    // exit();
// }

// Create a new PDF instance
$pdf = new TCPDF();
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Your Website Name');
$pdf->SetTitle('Property Details');
$pdf->SetHeaderData('', 0, '物件見積もりPDF', 'あなたの組織');
$pdf->setHeaderFont(['kozgopromedium', '', 12]); // Use your font
$pdf->setFooterFont(['kozgopromedium', '', 10]);
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
$pdf->AddPage();

// Set font for the PDF content
$pdf->SetFont('kozgopromedium', '', 12); // Set font for the content

// Initialize the HTML content
$html = '<h1>物件見積もりの詳細</h1>';
$html .= '<table border="1" cellpadding="5">';
$html .= '<tr>
              <th>建物番号</th>
              <th>備考</th>
              <th>選択したカテゴリ</th>
              <th>カラーオプション</th>
              <th>商品価格</th>
              <th>税金と割引価格</th>
              <th>合計価格</th> 
          </tr>';



        $html .= '<tr>
                      <td>' . esc_html($building_number) . '</td>
                      <td>' . esc_html($remarks) . '</td>
                      <td>' . $category_name . '</td>
                      <td>' . $post_title . '</td> 
                      <td>' . $price . ' 円</td>
                      <td>' . $total_price_sum . ' 円</td>
                      <td>' . $final_price . ' 円</td>
                  </tr>';



// Final row for totals
$html .= '<tr>
              <td colspan="6" align="right"><strong>合計:</strong></td>
               
              <td>' . number_format($final_price) . ' 円</td>
          </tr>';
$html .= '</table>';

// Write the HTML content into the PDF
$pdf->writeHTML($html, true, false, true, false, '');

// Output the PDF
$pdf->Output('property_details.pdf', 'I');
exit(); 