<!doctype html>
<html <?php language_attributes(); ?>>
<head>
 <title><?php bloginfo('name'); ?> <?php wp_title('|', true, 'left'); ?></title>
	<meta charset="<?php bloginfo( 'charset' ); ?>"> 
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<link rel="preconnect" href="https://fonts.googleapis.com">
   <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>

<?php wp_body_open(); ?>
<nav class="navbar navbar-expand-lg">
  <div class="container-fluid">
    <a class="navbar-brand" href="<?php echo get_home_url(); ?>"><img src="<?php the_field('logo','options'); ?>" alt="logo"></a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarSupportedContent">
      <ul class="navbar-nav">
        <li class="nav-item">
          <a class="nav-link active" aria-current="page" href="<?php echo get_home_url(); ?>"><?php the_field('header_heading','options'); ?></a>
		   <h6><?php the_field('header_sub_text','options'); ?></h6>
        </li>
        
      </ul>
     
    </div>
	  
  </div>
</nav>