<?php
add_action('wp_ajax_show_selected_items', 'show_selected_items');
add_action('wp_ajax_nopriv_show_selected_items', 'show_selected_items');

function show_selected_items() {
    $items = $_POST['items'];
    $result = [];
    $total = 0; // Initialize total price

    if (!empty($items)) {
        foreach ($items as $item) {
            if ($item['type'] == 'subcategory') {
                $subcategory_name = esc_html($item['name']);
                $subcategory_price = (float) $item['price']; // Convert to float
                $result[$subcategory_name] = [
                    'price' => $subcategory_price,
                    'posts' => []
                ];
                $total += $subcategory_price; // Add price to total
            }
            if ($item['type'] == 'post') {
                $post_name = esc_html($item['name']);
                $parent = esc_html($item['parent']);
                $result[$parent]['posts'][] = $post_name;
            }
        }
    }

    // Display Grouped Data
    if (!empty($result)) {
        echo '<ul>';
        foreach ($result as $subcategory => $data) {
            echo '<li>' . $subcategory . ' - ¥' . $data['price'] . '</li>';
            if (!empty($data['posts'])) {
                echo '<ul>';
                foreach ($data['posts'] as $post) {
                    echo '<li>' . $post . '</li>';
                }
                echo '</ul>';
            }
        }
        echo '</ul>';
        echo '<h3>Final Price: ¥' . $total . '</h3>'; // Display Final Price
    }

    wp_die();
}
