<?php 
/* Template Name: Home Page */
add_action('wp_enqueue_scripts', 'property_script');
function property_script() {
    wp_enqueue_script('jquery');
    wp_enqueue_style('property', get_stylesheet_directory_uri() . '/assets/css/homepage.css', array(), '01.07', 'all');

    wp_enqueue_script('property-ajax', get_stylesheet_directory_uri() . '/assets/js/homepage.js', array('jquery'), '01.05', true);
    // wp_localize_script('property-ajax', 'ajaxurl', admin_url('admin-ajax.php'));
    // wp_localize_script('property-ajax', 'ajax_params', array(
    //     'ajaxurl' => admin_url('admin-ajax.php'),
    //     'siteurl' => site_url() // Pass the site URL here
    // ));
}

get_header(); 
?>
<section class="optional-construction">
    <div class="container">
        <h4><?php the_field('section_1_heading'); ?></h4>
        <div class="bulding-calculation-form">
            <h3 class="form-heading"><?php the_field('form_heading'); ?></h3>
            <div class="form-desgin">
                <form id="construction-form">
                    <div class="form-row">
                        <div class="form-text">
                            <label for="propertyname"><?php the_field('property_name_label'); ?></label>
                            <input type="text" name="propertyname" id="propertyname" value="<?php the_field('property_name_value'); ?>" readonly>
                        </div>
                        <div class="form-number">
                            <input type="number" name="buildingnumber" id="buildingnumber" value="<?php the_field('building_number_value'); ?>"  readonly>
                            <label for="buildingnumber"><?php the_field('building_number_label'); ?></label>
                        </div>
                    </div>
                    <div class="form-remarks">
                        <label for="remarks"><?php the_field('state_label'); ?></label>
                        <input type="text" name="remarks" id="remarks" value="<?php the_field('state_value'); ?>" readonly>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>
<section class="agr-wapper">
    <div class="agr-main-wapper">
        <div class="container w-1100">
            <div class="agr-tab-menu">
                <?php
                $parent_terms = get_terms(array(
                    'taxonomy'   => 'property_type',
                    'hide_empty' => false,
                    'parent'     => 0,
                ));

                if (!empty($parent_terms) && !is_wp_error($parent_terms)) {
                    ?>
                    <ul>
                        <?php    
                        foreach ($parent_terms as $parent_term) { 
                        ?>
                            <li><a href="#" class="active" data-rel="<?php echo esc_html($parent_term->slug); ?>">
                                <span><?php echo esc_html($parent_term->name); ?></span>
                                <i><img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/img/arrow-icon.png" alt=""></i>
                            </a>
                        </li>
                    <?php } ?>
                </ul>
            <?php } ?>
        </div>
    </div>
    <div class="agr-tab-main-box">
     <?php    
     $category=1;
     foreach ($parent_terms as $parent_term) {  
         ?>
         <div class="agr-tab-box agr-category-view-main" data-categories="<?php echo esc_html($parent_term->slug); ?>" id="<?php echo esc_html($parent_term->slug); ?>" <?php if($category==1){ echo 'style="display:block;"';} ?>>
            <div class="agr-tab-price-show">
                <div class="container w-1100">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="agr-category-product">
                                <p id="agr-selected-category"  class="agr-selected-category"><?php echo esc_html($parent_term->name); ?></p>
                            </div>
                        </div>
                        <div class="col-lg-6 sub-category-priceinfo">
                            
                        </div>
                    </div>
                </div>
            </div>
            <?php
            $child_terms = get_terms(array(
                'taxonomy'   => 'property_type',
                'hide_empty' => false,
                'parent'     => $parent_term->term_id,
            ));
            if (!empty($child_terms) && !is_wp_error($child_terms)) {
                $child_count=1;
                foreach ($child_terms as $child_term) {
                   $child_term_description = get_term($child_term->term_id)->description;

                    $price = floatval(get_term_meta($child_term->term_id, '_property_price', true));
                    $discount = floatval(get_term_meta($child_term->term_id, '_property_discount', true));
                    $tax = floatval(get_term_meta($child_term->term_id, '_property_tax', true));
                    $final_price = floatval(get_term_meta($child_term->term_id, '_property_final_price', true));

                    if ($price > 0) {
                        $tax_amount = round($price * ($tax / 100));
                        $price_with_tax = $price + $tax_amount;
                        $discounted_price = $price - ($price * ($discount / 100));
                        $discount_amount = $price - $discounted_price;
                        $discounted_price_with_tax = $discounted_price + round($discounted_price * ($tax / 100));
                    } else {
                        $discounted_price = 0;
                        $discount_amount = 0;
                        $tax_amount = 0;
                        $price_with_tax = 0;
                        $discounted_price_with_tax = 0;
                    }
                    ?>
                    <div class="agr-category-view-wapper <?php if($child_count!=1){ echo ' mt-4';} ?>" id="<?php echo $child_term->slug; ?>">
                        <div class="container w-1100">
                            <div class="agr-category-top-card">
                                <div class="row">
                                    <div class="col-md-6">
                                        
                                        <div class="agr-main-checkbox-category">
                                            <input type="checkbox" sub-cat-name="<?php echo $child_term->name; ?>" data-input="<?php echo $child_term->slug; ?>" id="agr-category-<?php echo $child_term->slug; ?>" name="agr-category-<?php echo $child_term->slug; ?>" value="<?php echo $child_term->slug; ?>" class="agr-category-checkbox">
                                            <label for="agr-category-<?php echo $child_term->slug; ?>" class="agr-category-chekbox"><?php echo $child_term->name; ?></label>
                                        </div>

                                        <div class="agr-row-checkox">
                                            <div class="agr-category-fields">
                                                <div class="agr-value-checkbox">
                                                    <?php
                                                    $posts = get_posts(array(
                                                        'post_type'   => 'properties', 
                                                        'tax_query'   => array(
                                                            array(
                                                                'taxonomy' => 'property_type',
                                                                'field'    => 'term_id',
                                                                'terms'    => $child_term->term_id,
                                                            ),
                                                        ),
                                                        'numberposts' => -1,
                                                    ));

                                                    if (!empty($posts)) {
                                                       foreach ($posts as $post) {
                                                          $thumbnail = get_the_post_thumbnail_url($post->ID, 'full');
                                                          ?>
                                                          <span>
                                                            <input data-input="<?php echo $child_term->slug; ?>" type="checkbox" post-id="<?php echo $post->ID; ?>" id="agr-<?php echo  esc_attr($post->post_name); ?>" name="color" class="agr-color-checkbox" value="<?php echo  esc_attr($post->post_title); ?>" data-image="<?php echo esc_url($thumbnail); ?>">
                                                            <label for="agr-<?php echo  esc_attr($post->post_name); ?>"><?php echo  esc_attr($post->post_title); ?></label>
                                                        </span> 
                                                        <?php
                                                    }
                                                } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 agr-price-total" id="agr-category-price-<?php echo $child_term->slug; ?>">
                                 <div class="row">
                                    <div class="col-6">
                                        <div class="agr-Price">
                                            <h4 class="agr-category-price"><?php echo esc_attr(number_format($price, 0)); ?> yen</h4>
                                            <p>(Including installation cost)</p>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="agr-price">
                                            <h6 class="agr-category-price agr-total-price">
                                             
                                                <?php if ($tax > 0) { ?>
                                                   <?php echo esc_attr(number_format($price_with_tax, 0)); ?> yen (including tax)
                                                   <small>(Included ¥<?php echo esc_html(number_format($tax_amount, 0)); ?> Tax)</small>
                                               <?php } else { ?> <small>(No Tax)</small> <?php } ?>
                                           </h6>
                                           <p class="agr-category-price agr-discount-price agr-discount-excluding-tax">
                                            <?php if ($discount > 0) { ?> 
                                                <?php echo esc_attr(number_format($discounted_price, 0)); ?> yen (after discount)<br>
                                                <small>(Excluded ¥<?php echo esc_html(number_format($discount_amount, 0)); ?> Discount)</small><br>
                                            <?php }
                                                echo "<span class='agr-discount-price sub-cat-finalprice'>".esc_attr(number_format($final_price, 0)).' yen (Final Price)</span>';
                                            
                                            ?>
                                        </p>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
                <div class="row agr-product-grid-image" id="agr-product-grid-image-<?php echo $child_term->slug; ?>">
                    <div class="col-lg-7 mb-4 mb-lg-0">
                        <div class="agr-productImage">
                            <?php  if (!empty($posts)) {
                                                       foreach ($posts as $post) {
                                                          $thumbnail = get_the_post_thumbnail_url($post->ID, 'full');
                                                          ?>
                            <img id="agr-largeImage" src="<?php echo $thumbnail; ?>" alt="Product Image">
                             <?php
                             break;
                                                       }
                                 }
                                 ?>
                        </div>
                    </div>
                    <div class="col-sm-5 col-lg-5">
                        <div id="agr-thumbs">
                            <div class="row">
                                 <?php  if (!empty($posts)) {
                                     $index=0;
                                                       foreach ($posts as $post) {
                                                          $thumbnail = get_the_post_thumbnail_url($post->ID, 'full');
                                                          ?>
                                <div class="col-6">
                                    <div class="agr-thumbs-img">
                                        <img src="<?php echo $thumbnail; ?>" 
                                        alt="Thumbnail Image" 
                                        class="agr-product-image" 
                                        data-category="<?php echo $child_term->slug; ?>" 
                                        data-id="agr-<?php echo  esc_attr($post->post_name); ?>" 
                                        data-color-index="<?php echo $index; ?>" 
                                        data-color-value="<?php echo  esc_attr($post->post_title); ?>"
                                        post-id="<?php echo $post->ID; ?>"
                                        >
                                        <span><?php echo  esc_attr($post->post_title); ?></span>
                                    </div>
                                </div>
                                <?php
                                $index++;
                                                       }
                                 }
                                 ?>
                            </div>
                        </div>
                    </div>
                    <div class="agr-pdf-button">
                        <?php 
                          $per_post_pdf=get_stylesheet_directory_uri().'/generate-pdf.php?post_id=';
                        ?>

                        <a id="agr-generate-pdf-link" sub-id="<?php echo $child_term->slug; ?>" href="<?php echo $per_post_pdf; ?>" target="_blank">
                            <button class="agr-button-pdf-generate"> 詳細を見る
                                <span class="agr-images-pdf">
                                    <img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/img/Group-7649.png" class="agr-pdf-icon">
                                    <img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/img/Path-15206.png" class="agr-arrow-icon">
                                </span>
                            </button>
                        </a>
                    </div>
                    <div class="agr-product-discription">
                        <div class="agr-summary">
                            <span><?php echo $child_term_description; ?> </span>
                        </div>
                    </div>
                </div>
            </div>
        </div> 
        <?php 
        $child_count++;
    }
}
?>
</div>
<?php
$category++;
} 
?>
</div>
</div>
</div>
</section>
<div class="container confirmation-screen">
    <div class="confirmation-box">
        <a id="confirmationButton" href="#">
            <button class="confirmationbutton">
               To the confirmation screen          <img src="https://simplewebsite.cosmicinfluence.in/wp-content/uploads/2025/02/Group-2300.png">
            </button>
        </a>
    </div>   
</div>
<script>
jQuery(document).ready(function ($) {
    $('.agr-category-checkbox, .agr-color-checkbox, .agr-product-image').on('change click', function () {
        var subId = $(this).attr('data-input'); // Get sub-category slug
        
        // If the parent checkbox is changed, auto select the first child checkbox
        if ($(this).hasClass('agr-category-checkbox')) {
            var firstCheckbox = $('.agr-value-checkbox input[data-input="' + subId + '"]').first(); // First child checkbox
            $('.agr-value-checkbox input[data-input="' + subId + '"]').prop('checked', false); // Uncheck all child checkboxes
            firstCheckbox.prop('checked', true).trigger('change'); // Check first and trigger change
        }

        // If Image Clicked - Sync with Checkbox
        if ($(this).hasClass('agr-product-image')) {
            var targetId = $(this).attr('data-id');
            var targetCheckbox = $('#' + targetId);
            if (targetCheckbox.length) {
                targetCheckbox.prop('checked', true).trigger('change');
            }
        }

        // Get last selected checkbox
        var selectedCheckbox = $('input[data-input="' + subId + '"]:checked').last();
        
        if (selectedCheckbox.length > 0) {
            var postId = selectedCheckbox.attr('post-id'); // Get post ID
            var building = $('#buildingnumber').val(); // Fetch building number
            var remarks = $('#remarks').val(); // Fetch remarks
            
            var pdfUrl = '<?php echo get_stylesheet_directory_uri(); ?>/generate-pdf.php?buildingnumber=' + building + '&remarks=' + remarks + '&post_id=' + postId;

            // Update button href
            $('a[sub-id="' + subId + '"]').attr('href', pdfUrl);
        } else {
            // Remove href if no checkbox selected
            $('a[sub-id="' + subId + '"]').attr('href', '#');
        }
    });
});

// jQuery(document).ready(function ($) {
//     $('.agr-category-checkbox, .agr-color-checkbox').on('change', function () {
//         var subId = $(this).attr('data-input'); // Get sub-category slug
        
//         // If the parent checkbox is changed, auto select the first child checkbox
//         if ($(this).hasClass('agr-category-checkbox')) {
//             var firstCheckbox = $('.agr-value-checkbox input[data-input="' + subId + '"]').first(); // First child checkbox
//             $('.agr-value-checkbox input[data-input="' + subId + '"]').prop('checked', false); // Uncheck all child checkboxes
//             firstCheckbox.prop('checked', true).trigger('change'); // Check first and trigger change
//         }

//         // Get last selected checkbox
//         var selectedCheckbox = $('input[data-input="' + subId + '"]:checked').last(); 
        
//         if (selectedCheckbox.length > 0) {
//             var postId = selectedCheckbox.attr('post-id'); // Get post ID
//             var building = $('#buildingnumber').val(); // Fetch building number by ID
//             var remarks = $('#remarks').val(); // Fetch remarks by ID
            
//             var pdfUrl = '<?php //echo get_stylesheet_directory_uri(); ?>/generate-pdf.php?buildingnumber=' + building + '&remarks=' + remarks + '&post_id=' + postId;

//             // Update button href
//             $('a[sub-id="' + subId + '"]').attr('href', pdfUrl);
//             // Optional alert to test
//             // alert(pdfUrl);
//         } else {
//             // Remove href if no checkbox selected
//             $('a[sub-id="' + subId + '"]').attr('href', '#');
//         }
//     });
// });



function encrypt(text) {
    return btoa(text); // Base64 Encryption
}

document.querySelector('.confirmationbutton').addEventListener('click', function () {
    let selectedIds = [];

    // Loop through all selected checkboxes
    document.querySelectorAll('.agr-color-checkbox:checked').forEach(function (checkbox) {
        let postId = checkbox.getAttribute('post-id');
        if (postId) {
            selectedIds.push(encrypt(postId)); // Encrypt Post IDs
        }
    });

    if (selectedIds.length > 0) {
        let encryptedParam = encrypt('post_ids'); // Encrypt the parameter name
        let url = "<?php echo site_url('/option-application/'); ?>?" + encryptedParam + "=" + selectedIds.join(',');
        document.getElementById('confirmationButton').setAttribute('href', url);
    } else {
        alert('Please select at least one.');
    }
});
// document.addEventListener('DOMContentLoaded', function () {
//     const allCategoryBoxes = document.querySelectorAll('.agr-tab-box');

//     allCategoryBoxes.forEach(categoryBox => {
//         const categoryCheckboxes = categoryBox.querySelectorAll('.agr-category-checkbox');
//         const postCheckboxes = categoryBox.querySelectorAll('.agr-color-checkbox');
//         const selectedCategory = categoryBox.querySelector('.agr-selected-category');

//         // Handle Sub-Category Selection
//         categoryCheckboxes.forEach(categoryCheckbox => {
//             categoryCheckbox.addEventListener('change', function () {
//                 // Uncheck all category checkboxes
//                 categoryCheckboxes.forEach(cb => cb.checked = false);
//                 this.checked = true;

//                 const parentText = selectedCategory.dataset.parentText || selectedCategory.textContent.trim();
//                 selectedCategory.dataset.parentText = parentText; // Store original text

//                 if (this.checked) {
//                     selectedCategory.innerText = parentText + ' / ' + this.getAttribute('sub-cat-name');
//                     selectedCategory.dataset.subCategory = this.getAttribute('sub-cat-name'); // Store selected sub-category
//                 }
//             });
//         });

//         // Handle Post Selection inside Sub-Category
//         postCheckboxes.forEach(postCheckbox => {
//             postCheckbox.addEventListener('change', function () {
//                 const subCategory = selectedCategory.dataset.subCategory;

//                 if (this.checked && subCategory) {
//                     selectedCategory.innerText = selectedCategory.dataset.parentText + ' / ' + subCategory + ' / ' + this.value;
//                 }
//             });
//         });
//     });
// });
document.addEventListener('DOMContentLoaded', function () {
    const allCategoryBoxes = document.querySelectorAll('.agr-tab-box');

    allCategoryBoxes.forEach(categoryBox => {
        const categoryCheckboxes = categoryBox.querySelectorAll('.agr-category-checkbox');
        const colorCheckboxes = categoryBox.querySelectorAll('.agr-color-checkbox');
        const selectedCategory = categoryBox.querySelector('.agr-selected-category');

        // Store Parent Text
        selectedCategory.dataset.parentText = selectedCategory.textContent.trim();

        // Sub Category Selection
        categoryCheckboxes.forEach(categoryCheckbox => {
            categoryCheckbox.addEventListener('change', function () {
                categoryCheckboxes.forEach(cb => cb.checked = false);
                this.checked = true;

                const subCategory = this.getAttribute('sub-cat-name');

                if (this.checked) {
                    selectedCategory.innerText = selectedCategory.dataset.parentText + ' / ' + subCategory;
                }
            });
        });

        // Color Checkbox & Image Sync
        colorCheckboxes.forEach(colorCheckbox => {
            colorCheckbox.addEventListener('change', function () {
                const subCategory = categoryBox.querySelector('.agr-category-checkbox:checked')?.getAttribute('sub-cat-name') || '';
                
                if (this.checked) {
                    const postName = this.value;
                    selectedCategory.innerText = selectedCategory.dataset.parentText + ' / ' + subCategory + ' / ' + postName;
                }
            });
        });

        // Image Click Event
        const productImages = categoryBox.querySelectorAll('.agr-product-image');
        productImages.forEach(image => {
            image.addEventListener('click', function () {
                const targetId = this.dataset.id;
                const checkbox = document.getElementById(targetId);

                if (checkbox) {
                    checkbox.checked = !checkbox.checked;
                    checkbox.dispatchEvent(new Event('change'));
                }
            });
        });
    });
});

//=========
document.addEventListener('DOMContentLoaded', function () {
    const allCategoryBoxes = document.querySelectorAll('.agr-tab-box');

    allCategoryBoxes.forEach(categoryBox => {
        const categoryCheckboxes = categoryBox.querySelectorAll('.agr-category-checkbox');
        const subCategoryPriceInfo = categoryBox.querySelector('.sub-category-priceinfo');

        categoryCheckboxes.forEach(categoryCheckbox => {
            categoryCheckbox.addEventListener('change', function () {
                // Clear Previous Price Data
                subCategoryPriceInfo.innerHTML = '';

                // Uncheck all checkboxes in the same parent box
                categoryCheckboxes.forEach(cb => cb.checked = false);
                this.checked = true;

                if (this.checked) {
                    const slug = this.dataset.input; // Get Slug
                    const priceElement = document.querySelector(`#agr-category-price-${slug} .sub-cat-finalprice`); // Fetch Target Span Element
                    
                    if (priceElement) {
                        // Append Only Span HTML
                        subCategoryPriceInfo.innerHTML = priceElement.outerHTML;
                    }
                }
            });
        });
    });
});

</script>
<?php get_footer(); ?>