<?php
/* Template Name:Option Application */

get_header();
$front_page_id = get_option('page_on_front');  
?>
<section class="optional-construction">
    <div class="container">
        <h4><?php the_field('section_1_heading',$front_page_id );?></h4>
        <div class="bulding-calculation-form">
            <h3 class="form-heading"><?php the_field('form_heading',$front_page_id ); ?></h3>
            <div class="form-desgin">
                <form id="construction-form">
                    <div class="form-row">
                        <div class="form-text">
                            <label for="propertyname"><?php the_field('property_name_label',$front_page_id ); ?></label>
                            <input type="text" name="propertyname" id="propertyname" value="<?php the_field('property_name_value',$front_page_id ); ?>" readonly>
                        </div>
                        <div class="form-number">
                            <input type="number" name="buildingnumber" id="buildingnumber" value="<?php the_field('building_number_value',$front_page_id ); ?>"  readonly>
                            <label for="buildingnumber"><?php the_field('building_number_label',$front_page_id ); ?></label>
                        </div>
                    </div>
                    <div class="form-remarks">
                        <label for="remarks"><?php the_field('state_label',$front_page_id ); ?></label>
                        <input type="text" name="remarks" id="remarks" value="<?php the_field('state_value',$front_page_id ); ?>" readonly>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>
<style>
    .option-application-table td,.option-application-table th{
        padding:10px;
        text-align:center;
    }
    .price-td{text-align:right !important;}
</style>
<?php
// if (isset($_GET['post_ids'])) {
if (isset($_GET['cG9zdF9pZHM'])) { 
     $encrypted_ids = sanitize_text_field($_GET['cG9zdF9pZHM']);
    $param_name = base64_decode('cG9zdF9pZHM'); // This will decode the key name

        $post_ids = explode(',', $encrypted_ids);


    $total_price = 0; 
    $total_discounted_price = 0;
    $final_total = 0; 

    echo '<section class="category-view-verinent">
        <div class="container application-table-data">
            <div class="row">
                <table class="option-application-table" cellpadding="15" cellspacing="20">
                    <thead>
                        <tr>
                            <th>Property Name</th>
                            <th>Building Number</th>
                            <th>Remarks</th>
                            <th>Category</th>
                            <th>Color</th>
                            <th>Price (Include Tax) | (Exclude Discount)</th>
                        </tr>
                    </thead>
                    <tbody>';
    $postids_new=array();
    foreach ($post_ids as $id) {
         $post_id =  base64_decode($id); // Decode Post ID
          if (!empty($post_id)) {
        $postids_new[] = $post_id; // Store decoded IDs in array
    }
    $postids_new_string = implode(',', $postids_new); // Convert array to comma-separated string

        $post = get_post($post_id);
        
        if ($post) {
            $post_title = esc_html($post->post_title);
            $building_number = '1'; 
            $remarks = '-';
            $terms = wp_get_post_terms($post_id, 'property_type');
            $color = esc_html(get_post_meta($post_id, '_property_color', true));

            if (!empty($terms) && !is_wp_error($terms)) {
                $term = $terms[0];
                $category_name = esc_html($term->name);
                
                $price = floatval(get_term_meta($term->term_id, '_property_price', true));
                $discount = floatval(get_term_meta($term->term_id, '_property_discount', true));
                $tax = floatval(get_term_meta($term->term_id, '_property_tax', true));
                $final_price = floatval(get_term_meta($term->term_id, '_property_final_price', true));

                if ($price > 0) {
                    $discounted_price = $price - ($price * ($discount / 100));
                    $discount_amount = $price - $discounted_price;
                    $tax_amount = round($discounted_price * ($tax / 100));
                    $price_with_tax = $discounted_price + $tax_amount;
                } else {
                    $discounted_price = 0;
                    $discount_amount = 0;
                    $tax_amount = 0;
                    $price_with_tax = 0;
                }
                $final_total += $price_with_tax;

               echo '<tr data-name="' . esc_html($post_title) . '" 
           data-building="' . esc_html($building_number) . '" 
           data-remarks="' . esc_html($remarks) . '" 
           data-color="' . esc_html($post_title) . '" 
           data-price="' . esc_html($final_price) . '">
                        <td>-</td>
                        <td>' . $building_number . '</td>
                        <td>' . $remarks . '</td>
                        <td>' . $category_name . '</td>
                        <td>'. esc_html($post_title) . '</td>
                        <td class="price-td"><strong>¥' . number_format($final_price) . "</strong>";

                if ($tax > 0) {
                    echo '<small> (Included ¥' . esc_html(number_format($tax_amount)) . ' Tax)</small>';
                }

                if ($discount > 0) {
                    echo '<small> (Excluded ¥' . esc_html(number_format($discount_amount)) . ' Discount)</small>';
                }
                echo '</td></tr>';
            }
        }
    }

    echo '</tbody>
                </table>
                <p class="total"><strong>Total: ¥' . number_format($final_total) . ' JPY</strong></p> 
            </div>
        </div>
    </section>';
}
?>
 <div class="container">
 <div class="buttons-table">
 
	 <a href="<?php   echo  get_site_url();?>"><button class="edit-button">Edit content</button></a>
        <button class="pdf-button-option">Generate PDF</button>
        
            <p>If you agree to the above, please apply here.</p>
	         
    </div>
     
    <div class="arrow-image"> 
    <img id="arrow-image" src="https://simplewebsite.cosmicinfluence.in/wp-content/uploads/2025/02/Group-7684.png" class="down-arrow-image" alt="arrow">
    </div>
  </div>


<section class="form-application" style="display: none;">
    <div class="container application-form">
        <h1>オプション適用</h1>
        <p class="optional-construction">オプション工事のお申込み</p>
        <div class="application">
            <?php echo do_shortcode('[contact-form-7 id="da5f027" title="Contact form 1"]'); ?>
        </div>
    </div>
</section>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        document.querySelector(".pdf-button-option").addEventListener("click", function () {
            const urlParams = new URLSearchParams();
            urlParams.set("post_ids", "<?= $postids_new_string; ?>"); // Pass decoded post ids
            
            // Get form values
            let propertyname = document.getElementById("propertyname").value;
            let buildingnumber = document.getElementById("buildingnumber").value;
            let remarks = document.getElementById("remarks").value;

            urlParams.set("propertyname", propertyname);
            urlParams.set("buildingnumber", buildingnumber);
            urlParams.set("remarks", remarks);
            
            let pdfUrl = "<?= get_stylesheet_directory_uri(); ?>/option-application-pdf.php?" + urlParams.toString();
            window.location.href = pdfUrl; // Redirect to PDF Page
        });
    });
</script>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
jQuery(document).ready(function($) {
    $("#arrow-image").click(function() {
        $(".form-application").slideToggle(); // アニメーションでトグル
    });
});
</script>

<?php get_footer(); ?>